/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload.remoting;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.logging.Logger;
import org.jboss.profileservice.management.upload.AbstractTransientProfileManager;
import org.jboss.profileservice.management.upload.remoting.AbstractDeployHandler;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployHandler
extends AbstractDeployHandler {
    static final Logger log = Logger.getLogger(DeployHandler.class);
    private MutableProfile transientProfile;
    private ProfileService ps;
    private Map<String, VirtualFile> transientDeployments = new ConcurrentHashMap<String, VirtualFile>();

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
    }

    public void start() throws Exception {
        this.transientProfile = (MutableProfile)this.ps.getActiveProfile(AbstractTransientProfileManager.TRANSIENT_PROFILE_KEY);
    }

    @Override
    protected String[] getRepositoryNames(String[] names, DeploymentRepository deploymentRepository) throws Exception {
        List<String> repositoryNames = this.getTransientRepositoryNames(names);
        for (String name : super.getRepositoryNames(names, deploymentRepository)) {
            repositoryNames.add(name);
        }
        return repositoryNames.toArray(new String[repositoryNames.size()]);
    }

    @Override
    protected String[] distribute(DeploymentID dtID) throws Exception {
        URL contentURL = dtID.getContentURL();
        log.info((Object)("Begin distribute, content url: " + contentURL));
        VirtualFile vf = VFS.getRoot((URL)contentURL);
        ProfileDeployment deployment = this.createDeployment(vf);
        this.transientProfile.addDeployment(deployment);
        String name = deployment.getName();
        this.transientDeployments.put(name, vf);
        log.info((Object)("End distribute, " + name));
        return new String[]{name};
    }

    @Override
    protected ProfileDeployment scheduleStart(String name, DeploymentRepository deploymentRepository) throws Exception {
        String deploymentName = this.resolveDeploymentName(name);
        if (deploymentName != null) {
            ProfileDeployment deployment = this.transientProfile.getDeployment(deploymentName);
            this.transientProfile.addDeployment(deployment);
            return deployment;
        }
        ProfileDeployment deployment = deploymentRepository.getDeployment(name);
        deploymentRepository.unlockDeploymentContent(deployment.getName());
        return deployment;
    }

    @Override
    protected ProfileDeployment scheduleStop(String name, DeploymentRepository deploymentRepository) throws Exception {
        String deploymentName = this.resolveDeploymentName(name);
        if (deploymentName != null) {
            ProfileDeployment deployment = this.transientProfile.getDeployment(deploymentName);
            this.transientProfile.addDeployment(deployment);
            return deployment;
        }
        ProfileDeployment deployment = deploymentRepository.getDeployment(name);
        deploymentRepository.lockDeploymentContent(deployment.getName());
        return deployment;
    }

    @Override
    protected void removeDeployment(String name, DeploymentRepository deploymentRepository) throws Exception {
        String deploymentName = this.resolveDeploymentName(name);
        if (deploymentName != null) {
            this.transientDeployments.remove(deploymentName);
            this.transientProfile.removeDeployment(deploymentName);
        } else {
            deploymentRepository.removeDeployment(name);
        }
    }

    protected List<String> getTransientRepositoryNames(String[] names) {
        ArrayList<String> repositoryNames = new ArrayList<String>();
        for (String name : names) {
            if (this.transientDeployments.containsKey(name)) {
                repositoryNames.add(name);
                continue;
            }
            for (VirtualFile vf : this.transientDeployments.values()) {
                if (!vf.getName().equals(name)) continue;
                try {
                    repositoryNames.add(vf.toURI().toString());
                }
                catch (Exception ignored) {}
            }
        }
        return repositoryNames;
    }

    protected String resolveDeploymentName(String name) {
        String deploymentName = null;
        if (this.transientDeployments.containsKey(name)) {
            deploymentName = name;
        }
        if (deploymentName == null) {
            List<String> names = this.getTransientRepositoryNames(new String[]{name});
            if (names.size() == 1) {
                deploymentName = names.get(0);
            } else if (names.size() > 1) {
                throw new IllegalStateException("Multiple matching deployments found for name: " + name + " available " + names);
            }
        }
        return deploymentName;
    }
}

