/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.text;

public class NamingConverter {
    private final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public synchronized String decode(String value) {
        char[] ch = value.toCharArray();
        return NamingConverter.decode(ch, 0, ch.length, new char[1024]);
    }

    static synchronized String decode(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '-') {
                if ((aChar = in[off++]) != 'u') continue;
                int value = 0;
                block6: for (int i = 0; i < 4; ++i) {
                    aChar = in[off++];
                    switch (aChar) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            value = (value << 4) + aChar - 48;
                            continue block6;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            value = (value << 4) + 10 + aChar - 97;
                            continue block6;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            value = (value << 4) + 10 + aChar - 65;
                            continue block6;
                        }
                        default: {
                            throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                        }
                    }
                }
                out[outLen++] = (char)value;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public synchronized String encode(String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                outBuffer.append(aChar);
                continue;
            }
            if (aChar < ' ' || aChar > '~') {
                outBuffer.append('-');
                outBuffer.append('u');
                outBuffer.append(this.toHex(aChar >> 12 & 0xF));
                outBuffer.append(this.toHex(aChar >> 8 & 0xF));
                outBuffer.append(this.toHex(aChar >> 4 & 0xF));
                outBuffer.append(this.toHex(aChar & 0xF));
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private char toHex(int nibble) {
        return this.hexDigit[nibble & 0xF];
    }
}

