/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.oauth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.opensocial.oauth.ServiceProviderData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderStore {
    public static final String SHARED_SECRET = "sharedSecret";
    public static final String CONSUMER_KEY = "consumerKey";
    private static Log log = ExoLogger.getExoLogger(ServiceProviderStore.class);
    private Map<String, ServiceProviderData> providers;

    public ServiceProviderStore(Map<String, ServiceProviderData> consumerSecrets) {
        this.providers = consumerSecrets;
    }

    public ServiceProviderStore(InitParams params) {
        this.providers = new HashMap<String, ServiceProviderData>();
        try {
            Iterator it = params.getPropertiesParamIterator();
            while (it.hasNext()) {
                PropertiesParam propertiesParam = (PropertiesParam)it.next();
                String name = propertiesParam.getName();
                String description = propertiesParam.getDescription();
                String consumerKey = propertiesParam.getProperty(CONSUMER_KEY);
                String sharedSecret = propertiesParam.getProperty(SHARED_SECRET);
                ServiceProviderData provider = new ServiceProviderData(name, description, consumerKey, sharedSecret);
                this.providers.put(consumerKey, provider);
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to initialize properties from init-params", (Throwable)e);
        }
    }

    public ServiceProviderData getServiceProvider(String consumerKey) {
        return this.providers.get(consumerKey);
    }
}

