/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.managed.api.ComponentType;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
import org.jboss.resource.metadata.repository.DefaultJCAMetaDataRepository;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnectionFactoryDeployer
extends AbstractSimpleRealDeployer<ManagedConnectionFactoryDeploymentGroup> {
    private DefaultJCAMetaDataRepository repository;
    private List<AbstractBuilder> builders = new ArrayList<AbstractBuilder>();
    private String[] propNames = new String[]{"jndiName", "jdbcURL", "userName", "passWord", "driverClass", "minPoolSize", "maxPoolSize", "securityMetaData", "managedConnectionFactoryProperties"};
    private Map<String, String> propertyNameMappings = new HashMap<String, String>();

    public Map<String, String> getPropertyNameMappings() {
        return this.propertyNameMappings;
    }

    public void setPropertyNameMappings(Map<String, String> mangedToMBeanNames) {
        this.propertyNameMappings.clear();
        for (String key : mangedToMBeanNames.keySet()) {
            String value = mangedToMBeanNames.get(key);
            this.propertyNameMappings.put(value, key);
        }
    }

    public String[] getPropNames() {
        return this.propNames;
    }

    public void setPropNames(String[] propNames) {
        this.propNames = propNames;
    }

    public ManagedConnectionFactoryDeployer() {
        super(ManagedConnectionFactoryDeploymentGroup.class);
        this.setOutput(ServiceDeployment.class);
    }

    public void setBuilders(List<AbstractBuilder> builders) {
        this.builders = builders;
    }

    public List<AbstractBuilder> getBuilders() {
        return this.builders;
    }

    public DefaultJCAMetaDataRepository getRepository() {
        return this.repository;
    }

    public void setRepository(DefaultJCAMetaDataRepository repository) {
        this.repository = repository;
    }

    public void deploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup group) throws DeploymentException {
        List deployments = group.getDeployments();
        ServiceDeployment serviceDeployment = new ServiceDeployment();
        ArrayList<ServiceMetaData> componentServices = new ArrayList<ServiceMetaData>();
        List serviceDefintion = group.getServices();
        serviceDeployment.setName(unit.getName() + " services");
        for (ServiceMetaData data : serviceDefintion) {
            componentServices.add(data);
        }
        ComponentType type = null;
        for (ManagedConnectionFactoryDeploymentMetaData data : deployments) {
            if (type == null) {
                if (data instanceof LocalDataSourceDeploymentMetaData) {
                    type = KnownComponentTypes.DataSourceTypes.LocalTx.getType();
                }
                if (data instanceof NoTxDataSourceDeploymentMetaData) {
                    type = KnownComponentTypes.DataSourceTypes.NoTx.getType();
                }
                if (data instanceof XADataSourceDeploymentMetaData) {
                    type = KnownComponentTypes.DataSourceTypes.XA.getType();
                }
            }
            for (AbstractBuilder builder : this.builders) {
                ServiceMetaData candidate = builder.build(data);
                if (candidate == null) continue;
                componentServices.add(candidate);
            }
        }
        serviceDeployment.setServices(componentServices);
        unit.addAttachment(ServiceDeployment.class, (Object)serviceDeployment);
        if (type != null) {
            unit.addAttachment(ComponentType.class, (Object)type);
        }
    }

    public void undeploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup deployment) {
    }
}

