/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.File;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractContentMetadataMutatorAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryTimestampUpdateAction
extends AbstractContentMetadataMutatorAction<FileBasedSynchronizationActionContext> {
    private final File targetDir;
    private final long rollbackTimestamp;

    public DirectoryTimestampUpdateAction(File targetDir, FileBasedSynchronizationActionContext context, ContentModification modification) {
        super(context, modification);
        if (targetDir == null) {
            throw new IllegalArgumentException("Null targetDir");
        }
        if (!targetDir.exists()) {
            throw new IllegalArgumentException(targetDir + " does not exist");
        }
        if (!targetDir.isDirectory()) {
            throw new IllegalArgumentException(targetDir + " is not a directory");
        }
        this.targetDir = targetDir;
        this.rollbackTimestamp = targetDir.lastModified();
    }

    @Override
    protected void doCancel() {
    }

    @Override
    protected void doCommit() {
        this.updateContentMetadata();
    }

    @Override
    protected void doComplete() throws Exception {
    }

    @Override
    protected boolean doPrepare() {
        this.targetDir.setLastModified(this.getRepositoryContentModification().getItem().getTimestamp());
        return true;
    }

    @Override
    protected void doRollbackFromCancelled() {
    }

    @Override
    protected void doRollbackFromComplete() {
    }

    @Override
    protected void doRollbackFromOpen() {
    }

    @Override
    protected void doRollbackFromPrepared() {
        this.targetDir.setLastModified(this.rollbackTimestamp);
    }

    @Override
    protected void doRollbackFromRollbackOnly() {
        this.targetDir.setLastModified(this.rollbackTimestamp);
    }
}

