/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.picketlink.idm.cache.APICacheProvider;

@Managed
@ManagedDescription(value="PicketLink IDM Cache Service")
@NameTemplate(value={@Property(key="name", value="plidmcache"), @Property(key="service", value="PicketLinkIDMCacheService")})
@RESTEndpoint(path="plidmcache")
public class PicketLinkIDMCacheService {
    private final List<APICacheProvider> cacheProviders = new LinkedList<APICacheProvider>();

    public void register(APICacheProvider cacheProvider) {
        if (cacheProvider != null) {
            this.cacheProviders.add(cacheProvider);
        }
    }

    @Managed
    @ManagedDescription(value="Ivalidate cache namespace")
    @Impact(value=ImpactType.WRITE)
    public void invalidate(@ManagedDescription(value="Cache namespace") @ManagedName(value="namespace") String namespace) {
        for (APICacheProvider cacheProvider : this.cacheProviders) {
            cacheProvider.invalidate(namespace);
        }
    }

    @Managed
    @ManagedDescription(value="Ivalidate all caches")
    @Impact(value=ImpactType.WRITE)
    public void invalidateAll() {
        for (APICacheProvider cacheProvider : this.cacheProviders) {
            cacheProvider.invalidateAll();
        }
    }
}

