/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;

@DiscriminatorValue(value="EMAIL")
@Entity
@NamedQueries(value={@NamedQuery(name="EmailNotification.findAllByAlertDefinitionId", query="SELECT en   FROM EmailNotification en  WHERE en.alertDefinition.id = :alertDefinitionId "), @NamedQuery(name="EmailNotification.findByIds", query="SELECT en   FROM EmailNotification en  WHERE en.id IN ( :ids )")})
public class EmailNotification
extends AlertNotification {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL_BY_ALERT_DEFINITION_ID = "EmailNotification.findAllByAlertDefinitionId";
    public static final String QUERY_FIND_BY_IDS = "EmailNotification.findByIds";
    @Column(name="EMAIL_ADDRESS", nullable=false)
    private String emailAddress;

    protected EmailNotification() {
    }

    public EmailNotification(EmailNotification emailNotification) {
        this(emailNotification.getAlertDefinition(), emailNotification.emailAddress);
    }

    public EmailNotification(@NotNull AlertDefinition alertDefinition, @NotNull String emailAddress) {
        super(alertDefinition);
        if (emailAddress == null) {
            throw new IllegalArgumentException("emailAddress must be non-null.");
        }
        this.emailAddress = emailAddress;
    }

    @NotNull
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public AlertNotification copy() {
        return new EmailNotification(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.toLowerCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof EmailNotification)) {
            return false;
        }
        EmailNotification other = (EmailNotification)obj;
        if (this.emailAddress == null) {
            return other.emailAddress == null;
        }
        return this.emailAddress.equalsIgnoreCase(other.emailAddress);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "id=" + this.getId() + ", " + "emailAddress=" + this.emailAddress + ", " + "]";
    }
}

