/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.ExHyperlink;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.TxInteractiveInfoAtom;
import org.apache.poi.hslf.usermodel.SlideShow;

public class Hyperlink {
    private int type;
    private String address;
    private String title;
    private int startIndex;
    private int endIndex;

    public int getType() {
        return this.type;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTitle() {
        return this.title;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    protected static Hyperlink[] find(TextRun run) {
        ArrayList lst = new ArrayList();
        SlideShow ppt = run.getSheet().getSlideShow();
        ExObjList exobj = ppt.getDocumentRecord().getExObjList();
        if (exobj == null) {
            return null;
        }
        Record[] records = run._records;
        if (records != null) {
            Hyperlink.find(records, exobj, lst);
        }
        Hyperlink[] links = null;
        if (lst.size() > 0) {
            links = new Hyperlink[lst.size()];
            lst.toArray(links);
        }
        return links;
    }

    protected static Hyperlink find(Shape shape) {
        ArrayList lst = new ArrayList();
        SlideShow ppt = shape.getSheet().getSlideShow();
        ExObjList exobj = ppt.getDocumentRecord().getExObjList();
        if (exobj == null) {
            return null;
        }
        EscherContainerRecord spContainer = shape.getSpContainer();
        List spchild = spContainer.getChildRecords();
        Iterator it = spchild.iterator();
        while (it.hasNext()) {
            byte[] data;
            Record[] records;
            EscherRecord obj = (EscherRecord)it.next();
            if (obj.getRecordId() != -4079 || (records = Record.findChildRecords(data = ((EscherContainerRecord)obj).serialize(), 8, data.length - 8)) == null) continue;
            Hyperlink.find(records, exobj, lst);
        }
        return lst.size() == 1 ? (Hyperlink)lst.get(0) : null;
    }

    private static void find(Record[] records, ExObjList exobj, List out) {
        for (int i = 0; i < records.length; ++i) {
            InteractiveInfo hldr;
            InteractiveInfoAtom info;
            int id;
            ExHyperlink linkRecord;
            if (!(records[i] instanceof InteractiveInfo) || (linkRecord = exobj.get(id = (info = (hldr = (InteractiveInfo)records[i]).getInteractiveInfoAtom()).getHyperlinkID())) == null) continue;
            Hyperlink link = new Hyperlink();
            link.title = linkRecord.getLinkTitle();
            link.address = linkRecord.getLinkURL();
            link.type = info.getAction();
            if (++i < records.length && records[i] instanceof TxInteractiveInfoAtom) {
                TxInteractiveInfoAtom txinfo = (TxInteractiveInfoAtom)records[i];
                link.startIndex = txinfo.getStartIndex();
                link.endIndex = txinfo.getEndIndex();
            }
            out.add(link);
        }
    }
}

