/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericOperationEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public class UnaryMinusEval
extends NumericOperationEval {
    private UnaryMinusPtg delegate;
    private static final ValueEvalToNumericXlator NUM_XLATOR = new ValueEvalToNumericXlator(219);

    public UnaryMinusEval(Ptg ptg) {
        this.delegate = (UnaryMinusPtg)ptg;
    }

    protected ValueEvalToNumericXlator getXlator() {
        return NUM_XLATOR;
    }

    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        ValueEval retval = null;
        double d = 0.0;
        switch (operands.length) {
            default: {
                retval = ErrorEval.UNKNOWN_ERROR;
                break;
            }
            case 1: {
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    d = ((NumericValueEval)ve).getNumberValue();
                    break;
                }
                if (ve instanceof BlankEval || !(ve instanceof ErrorEval)) break;
                retval = ve;
            }
        }
        if (retval == null) {
            retval = new NumberEval(-d);
        }
        return retval;
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }

    public int getType() {
        return this.delegate.getType();
    }
}

