/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.annotations.Element;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.deployer.helpers.AnnotationProcessor;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAnnotationDeployer
extends AbstractSimpleRealDeployer<AnnotationEnvironment> {
    private AnnotationProcessor<?, ?>[] processors;

    public AbstractAnnotationDeployer(AnnotationProcessor<?, ?> ... processors) {
        super(AnnotationEnvironment.class);
        if (processors != null && processors.length > 0) {
            this.processors = processors;
            for (AnnotationProcessor<?, ?> processor : processors) {
                this.addInput(processor.getAnnotation());
                this.addOutput(processor.getOutput());
            }
        } else {
            throw new IllegalArgumentException("Null or empty processors.");
        }
    }

    @Override
    public void deploy(DeploymentUnit unit, AnnotationEnvironment deployment) throws DeploymentException {
        for (AnnotationProcessor<?, ?> processor : this.processors) {
            String attachmentName = processor.getAnnotation().getName();
            Object annotationAttachment = unit.getAttachment(attachmentName);
            Object metadata = processor.createMetaData(annotationAttachment);
            if (metadata != null) {
                unit.addAttachment(attachmentName, metadata);
            }
            Set<Element<?, Class<?>>> elements = deployment.classIsAnnotatedWith(processor.getAnnotation());
            for (Element<?, Class<?>> elt : elements) {
                Class<?> clazz = elt.getOwner();
                metadata = processor.createMetaDataFromClass(clazz);
                if (metadata == null) continue;
                unit.addAttachment(attachmentName + "#" + clazz.getName(), metadata);
            }
        }
    }
}

