/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.registry.basic;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryAlreadyRegisteredException;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.logging.Logger;

public class BasicKernelRegistryFactory
implements KernelRegistryPlugin {
    private static final Logger log = Logger.getLogger(BasicKernelRegistryFactory.class);
    protected Map<Object, KernelRegistryEntry> entries = new ConcurrentHashMap<Object, KernelRegistryEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEntry(Object name, KernelRegistryEntry entry) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        boolean trace = log.isTraceEnabled();
        Map<Object, KernelRegistryEntry> map = this.entries;
        synchronized (map) {
            if (this.entries.containsKey(name)) {
                throw new KernelRegistryEntryAlreadyRegisteredException("Already registered: " + name);
            }
            this.entries.put(name, entry);
            entry.setName(name);
        }
        if (trace) {
            log.trace((Object)("Registered object: '" + entry + "' with name '" + name + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelRegistryEntry unregisterEntry(Object name) {
        KernelRegistryEntry entry;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean trace = log.isTraceEnabled();
        Map<Object, KernelRegistryEntry> map = this.entries;
        synchronized (map) {
            entry = this.entries.remove(name);
            if (entry == null) {
                throw new KernelRegistryEntryNotFoundException("Not found: " + name);
            }
        }
        if (trace) {
            log.trace((Object)("Unregistered name: '" + name + "'"));
        }
        return entry;
    }

    public KernelRegistryEntry getEntry(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.entries.get(name);
    }
}

