/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.lock;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.replication.ReplicationService;
import org.exoplatform.services.jcr.impl.core.lock.FileSystemLockPersister;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ReplicationLockPersister
extends FileSystemLockPersister {
    private final ReplicationService replicationService;
    private static Log log = ExoLogger.getLogger("ext.ReplicationLockPersister");
    private static final int START_TIMEOUT = 250;
    private Thread delayStarterThread;

    public ReplicationLockPersister(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, ReplicationService service) throws RepositoryConfigurationException, RepositoryException {
        super(dataManager, config);
        log.info("init");
        this.replicationService = service;
    }

    public void start() {
        log.info("start");
        this.delayStarterThread = new Thread(new DelaySatrter());
        this.delayStarterThread.start();
    }

    private void superStart() {
        super.start();
    }

    public void stop() {
        log.info("stop");
    }

    class DelaySatrter
    implements Runnable {
        DelaySatrter() {
        }

        public void run() {
            try {
                while (!ReplicationLockPersister.this.replicationService.isStarted()) {
                    Thread.sleep(250L);
                }
                ReplicationLockPersister.this.superStart();
            }
            catch (InterruptedException ie) {
                log.error("Can not start", ie);
            }
        }
    }
}

