/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm.text;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.jsecurity.authc.SimpleAccount;
import org.jsecurity.authz.Permission;
import org.jsecurity.authz.SimpleRole;
import org.jsecurity.realm.SimpleAccountRealm;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.util.PermissionUtils;
import org.jsecurity.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextConfigurationRealm
extends SimpleAccountRealm {
    private String userDefinitions;
    private String roleDefinitions;

    public String getUserDefinitions() {
        return this.userDefinitions;
    }

    public void setUserDefinitions(String userDefinitions) {
        this.userDefinitions = userDefinitions;
    }

    public String getRoleDefinitions() {
        return this.roleDefinitions;
    }

    public void setRoleDefinitions(String roleDefinitions) {
        this.roleDefinitions = roleDefinitions;
    }

    @Override
    protected void accountAndRoleCachesCreated() {
        this.processDefinitions();
    }

    protected void processDefinitions() {
        try {
            this.processRoleDefinitions();
            this.processUserDefinitions();
        }
        catch (ParseException e) {
            String msg = "Unable to parse user and/or role definitions.";
            throw new IllegalStateException(msg, e);
        }
    }

    protected void processRoleDefinitions() throws ParseException {
        String roleDefinitions = this.getRoleDefinitions();
        if (roleDefinitions == null) {
            return;
        }
        Map<String, String> roleDefs = TextConfigurationRealm.toMap(TextConfigurationRealm.toLines(roleDefinitions));
        if (roleDefs == null || roleDefs.isEmpty()) {
            return;
        }
        for (String rolename : roleDefs.keySet()) {
            String value = roleDefs.get(rolename);
            SimpleRole role = this.getRole(rolename);
            if (role == null) {
                role = new SimpleRole(rolename);
                this.add(role);
            }
            Set<Permission> permissions = PermissionUtils.resolveDelimitedPermissions(value, this.getPermissionResolver());
            role.setPermissions(permissions);
        }
    }

    protected void processUserDefinitions() throws ParseException {
        String userDefinitions = this.getUserDefinitions();
        if (userDefinitions == null) {
            return;
        }
        Map<String, String> userDefs = TextConfigurationRealm.toMap(TextConfigurationRealm.toLines(userDefinitions));
        if (userDefs == null || userDefs.isEmpty()) {
            return;
        }
        for (String username : userDefs.keySet()) {
            String value = userDefs.get(username);
            String[] passwordAndRolesArray = StringUtils.split(value);
            String password = passwordAndRolesArray[0];
            SimpleAccount account = this.getUser(username);
            if (account == null) {
                account = new SimpleAccount(username, (Object)password, this.getName());
                this.add(account);
            }
            account.setCredentials(password);
            if (passwordAndRolesArray.length > 1) {
                for (int i = 1; i < passwordAndRolesArray.length; ++i) {
                    String rolename = passwordAndRolesArray[i];
                    account.addRole(rolename);
                    SimpleRole role = this.getRole(rolename);
                    if (role == null) continue;
                    account.addObjectPermissions(role.getPermissions());
                }
                continue;
            }
            account.setRoles(null);
        }
    }

    protected static Set<String> toLines(String s) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Scanner scanner = new Scanner(s);
        while (scanner.hasNextLine()) {
            set.add(scanner.nextLine());
        }
        return set;
    }

    protected static Map<String, String> toMap(Collection<String> keyValuePairs) throws ParseException {
        if (keyValuePairs == null || keyValuePairs.isEmpty()) {
            return null;
        }
        HashMap<String, String> pairs = new HashMap<String, String>();
        for (String pairString : keyValuePairs) {
            String[] pair = StringUtils.splitKeyValue(pairString);
            pairs.put(pair[0].trim(), pair[1].trim());
        }
        return pairs;
    }

    @Override
    public void onLogout(PrincipalCollection accountPrincipal) {
    }
}

