/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence.deployer;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.attachments.AttachmentMetaData;
import org.jboss.system.server.profileservice.attachments.AttachmentStore;
import org.jboss.system.server.profileservice.attachments.RepositoryAttachmentMetaData;
import org.jboss.system.server.profileservice.persistence.PersistenceFactory;
import org.jboss.system.server.profileservice.persistence.deployer.PersistenceModificationChecker;
import org.jboss.system.server.profileservice.persistence.xml.PersistenceRoot;
import org.jboss.virtual.VirtualFile;

public class ProfileServicePersistenceDeployer
extends AbstractRealDeployer {
    public static final String PERSISTED_ATTACHMENT_PREFIX = "PERISTED";
    private AttachmentStore store;
    private PersistenceFactory persistenceFactory;
    private static final Logger log = Logger.getLogger(ProfileServicePersistenceDeployer.class);

    public ProfileServicePersistenceDeployer() {
        this.setAllInputs(true);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    public PersistenceFactory getPersistenceFactory() {
        return this.persistenceFactory;
    }

    public void setPersistenceFactory(PersistenceFactory persistenceFactory) {
        this.persistenceFactory = persistenceFactory;
    }

    public AttachmentStore getAttachmentStore() {
        return this.store;
    }

    public void setAttachmentStore(AttachmentStore store) {
        this.store = store;
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (unit == null || !(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        try {
            this.applyPersistentChanges((VFSDeploymentUnit)unit);
        }
        catch (Throwable e) {
            log.warn((Object)"Failed to update the persisted attachment information", e);
        }
    }

    protected void applyPersistentChanges(VFSDeploymentUnit unit) throws Throwable {
        VirtualFile vf = unit.getRoot();
        RepositoryAttachmentMetaData metaData = this.store.loadMetaData(vf);
        if (metaData == null) {
            return;
        }
        if (PersistenceModificationChecker.hasBeenModified(unit, metaData.getLastModified())) {
            log.debug((Object)("Deployment was modified, not applying persisted information : " + unit));
            return;
        }
        if (metaData.getAttachments() != null && !metaData.getAttachments().isEmpty()) {
            for (AttachmentMetaData attachment : metaData.getAttachments()) {
                Object instance = unit.getAttachment(attachment.getName());
                if (instance != null) {
                    PersistenceRoot root = this.store.loadAttachment(vf, attachment);
                    if (root == null) {
                        log.warn((Object)("Null persisted information for deployment: " + vf));
                    }
                    this.getPersistenceFactory().restorePersistenceRoot(root, instance, unit.getClassLoader());
                    continue;
                }
                log.warn((Object)("Could not apply changes, failed to find attachment: " + attachment.getName()));
            }
        }
    }
}

