/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AppConfigurationEntryHolder;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.authorization.config.AuthorizationConfigEntryHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.SecurityActions;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.xb.binding.GenericValueContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPolicyContainer
implements GenericValueContainer {
    private static Logger log = Logger.getLogger(ApplicationPolicyContainer.class);
    ApplicationPolicy info = null;
    String authName = null;
    String baseAppPolicyName = null;
    List authenticationModuleEntries = new ArrayList();
    List<AuthorizationModuleEntry> authorizationModuleEntries = new ArrayList<AuthorizationModuleEntry>();
    List<AuditProviderEntry> auditProviderEntries = new ArrayList<AuditProviderEntry>();
    List<IdentityTrustModuleEntry> identityTrustModuleEntries = new ArrayList<IdentityTrustModuleEntry>();
    Map<String, LoginModuleStackHolder> loginModuleStackMap = new HashMap<String, LoginModuleStackHolder>();
    boolean isJASPIAuthentication = false;
    boolean isJAASAuthentication = false;
    boolean isAuthorization = false;
    boolean containsAudit = false;
    boolean containsIdentityTrust = false;
    boolean containsRoleMapping = false;
    Map<String, MappingInfo> mappingInfos = new HashMap<String, MappingInfo>();
    ACLInfo aclInfo = null;
    AuditInfo auditInfo = null;
    IdentityTrustInfo identityTrustInfo = null;

    public void addChild(QName name, Object value) {
        log.debug((Object)("addChild::" + name + ":" + value));
        if ("name".equals(name.getLocalPart())) {
            this.authName = (String)value;
        } else if ("extends".equals(name.getLocalPart())) {
            this.baseAppPolicyName = (String)value;
        } else if (value instanceof AppConfigurationEntryHolder) {
            AppConfigurationEntryHolder ace = (AppConfigurationEntryHolder)value;
            this.authenticationModuleEntries.add(ace.getEntry());
            this.isJAASAuthentication = true;
        } else if (value instanceof AppConfigurationEntry) {
            AppConfigurationEntry ace = (AppConfigurationEntry)value;
            this.authenticationModuleEntries.add(ace);
            this.isJAASAuthentication = true;
        } else if (value instanceof AuthModuleEntry) {
            AuthModuleEntry ame = (AuthModuleEntry)value;
            String lmshName = ame.getLoginModuleStackHolderName();
            if (lmshName != null) {
                ame.setLoginModuleStackHolder(this.loginModuleStackMap.get(lmshName));
            }
            this.authenticationModuleEntries.add(ame);
            this.isJASPIAuthentication = true;
        } else if (value instanceof LoginModuleStackHolder) {
            LoginModuleStackHolder lmsh = (LoginModuleStackHolder)value;
            this.loginModuleStackMap.put(lmsh.getName(), lmsh);
            this.isJASPIAuthentication = true;
        } else if (value instanceof AuthorizationModuleEntry) {
            AuthorizationModuleEntry ame = (AuthorizationModuleEntry)value;
            if (!this.authorizationModuleEntries.contains(ame)) {
                this.authorizationModuleEntries.add(ame);
            }
            this.isAuthorization = true;
        } else if (value instanceof AuthorizationConfigEntryHolder) {
            AuthorizationConfigEntryHolder ame = (AuthorizationConfigEntryHolder)value;
            AuthorizationModuleEntry ameEntry = ame.getEntry();
            if (!this.authorizationModuleEntries.contains(ameEntry)) {
                this.authorizationModuleEntries.add(ameEntry);
            }
            this.isAuthorization = true;
        } else if (value instanceof AuditProviderEntry) {
            AuditProviderEntry ameEntry = (AuditProviderEntry)value;
            if (!this.auditProviderEntries.contains(ameEntry)) {
                this.auditProviderEntries.add(ameEntry);
            }
            this.containsAudit = true;
        } else if (value instanceof IdentityTrustModuleEntry) {
            IdentityTrustModuleEntry ameEntry = (IdentityTrustModuleEntry)value;
            if (!this.identityTrustModuleEntries.contains(ameEntry)) {
                this.identityTrustModuleEntries.add(ameEntry);
            }
            this.containsIdentityTrust = true;
        }
    }

    public void addMappingInfo(Object obj) {
        log.debug(obj);
        if (obj instanceof Map) {
            this.mappingInfos.putAll((Map)obj);
            for (MappingInfo info : this.mappingInfos.values()) {
                info.setName(this.authName);
            }
            this.containsRoleMapping = true;
        }
    }

    public void addACLInfo(Object info) {
        if (info instanceof ACLInfo) {
            this.aclInfo = (ACLInfo)info;
            this.aclInfo.setName(this.authName);
        }
    }

    public Object instantiate() {
        this.info = new ApplicationPolicy(this.authName);
        if (this.baseAppPolicyName != null) {
            this.info.setBaseApplicationPolicyName(this.baseAppPolicyName);
        }
        AuthenticationInfo binfo = null;
        AuthorizationInfo ainfo = null;
        if (this.isJAASAuthentication) {
            binfo = new AuthenticationInfo(this.authName);
            SecurityActions.addModules(binfo, this.authenticationModuleEntries);
            this.info.setAuthenticationInfo(binfo);
        }
        if (this.isJASPIAuthentication) {
            JASPIAuthenticationInfo jaspiInfo = new JASPIAuthenticationInfo(this.authName);
            SecurityActions.addModules(jaspiInfo, this.authenticationModuleEntries);
            for (LoginModuleStackHolder holder : this.loginModuleStackMap.values()) {
                jaspiInfo.add(holder);
            }
            this.info.setAuthenticationInfo(jaspiInfo);
        }
        if (this.isAuthorization) {
            ainfo = new AuthorizationInfo(this.authName);
            SecurityActions.addModules(ainfo, this.authorizationModuleEntries);
            this.info.setAuthorizationInfo(ainfo);
        }
        if (this.aclInfo != null) {
            this.info.setAclInfo(this.aclInfo);
        }
        if (this.containsRoleMapping) {
            for (String type : this.mappingInfos.keySet()) {
                this.info.setMappingInfo(type, this.mappingInfos.get(type));
            }
        }
        if (this.containsAudit) {
            this.auditInfo = new AuditInfo(this.authName);
            SecurityActions.addModules(this.auditInfo, this.auditProviderEntries);
            this.info.setAuditInfo(this.auditInfo);
        }
        if (this.containsIdentityTrust) {
            this.identityTrustInfo = new IdentityTrustInfo(this.authName);
            SecurityActions.addModules(this.identityTrustInfo, this.identityTrustModuleEntries);
            this.info.setIdentityTrustInfo(this.identityTrustInfo);
        }
        return this.info;
    }

    public Class<?> getTargetClass() {
        return ApplicationPolicy.class;
    }
}

