/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.group;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.auth.Subject;

@MappedSuperclass
public abstract class Group
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="LOCATION")
    private String location;
    @Column(name="CTIME")
    private Long ctime;
    @Column(name="MTIME")
    private Long mtime;
    @JoinColumn(name="MODIFIED_BY")
    @ManyToOne(fetch=FetchType.LAZY)
    private Subject modifiedBy;

    protected Group() {
    }

    public Group(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getCtime() {
        return this.ctime;
    }

    public void setCtime(Long ctime) {
        this.ctime = ctime;
    }

    public Long getMtime() {
        return this.mtime;
    }

    public void setMtime(Long mtime) {
        this.mtime = mtime;
    }

    public Subject getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Subject modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Group)) {
            return false;
        }
        Group group = (Group)o;
        return this.name.equals(group.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @PrePersist
    void onPersist() {
        this.mtime = System.currentTimeMillis();
        this.ctime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }
}

