/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.kernel;

import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;

public class LazyJNDIKernelRegistryEntry
extends AbstractKernelRegistryEntry {
    private Context ctx;

    public LazyJNDIKernelRegistryEntry(Context ctx, String name) {
        super((Object)name);
        this.ctx = ctx;
    }

    public Object getTarget() {
        assert (this.name instanceof String) : "Cannot determine target for object of type " + this.getName() + " - expected String";
        try {
            Object boundObject = this.ctx.lookup((String)this.getName());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found KernelRegistryEntry with name " + this.getName() + " in jndi"));
            }
            return boundObject;
        }
        catch (NameNotFoundException nnfe) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Target for KernelRegistryEntry with name " + this.getName() + " not found in jndi"));
            }
            return null;
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not obtain target from KernelRegistryEntry for name " + this.getName(), e);
        }
    }
}

