/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.Date;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.GetTCLAction;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCOptimisticLockingMetaData {
    public static final Integer FIELD_GROUP_STRATEGY = new Integer(1);
    public static final Integer MODIFIED_STRATEGY = new Integer(2);
    public static final Integer READ_STRATEGY = new Integer(4);
    public static final Integer VERSION_COLUMN_STRATEGY = new Integer(8);
    public static final Integer TIMESTAMP_COLUMN_STRATEGY = new Integer(16);
    public static final Integer KEYGENERATOR_COLUMN_STRATEGY = new Integer(32);
    private final Integer lockingStrategy;
    private final String groupName;
    private final JDBCCMPFieldMetaData lockingField;
    private final String keyGeneratorFactory;
    private final Logger log;

    public JDBCOptimisticLockingMetaData(JDBCEntityMetaData entityMetaData, Element element) throws DeploymentException {
        this.log = Logger.getLogger((String)entityMetaData.getName());
        Element strategyEl = MetaData.getOptionalChild((Element)element, (String)"group-name");
        if (strategyEl != null) {
            this.lockingStrategy = FIELD_GROUP_STRATEGY;
            this.groupName = MetaData.getElementContent((Element)strategyEl);
            this.lockingField = null;
            this.keyGeneratorFactory = null;
            this.log.debug((Object)("optimistic locking: group=" + this.groupName));
        } else {
            strategyEl = MetaData.getOptionalChild((Element)element, (String)"modified-strategy");
            if (strategyEl != null) {
                this.lockingStrategy = MODIFIED_STRATEGY;
                this.groupName = null;
                this.lockingField = null;
                this.keyGeneratorFactory = null;
                this.log.debug((Object)"optimistic locking: modified strategy");
            } else {
                strategyEl = MetaData.getOptionalChild((Element)element, (String)"read-strategy");
                if (strategyEl != null) {
                    this.lockingStrategy = READ_STRATEGY;
                    this.groupName = null;
                    this.lockingField = null;
                    this.keyGeneratorFactory = null;
                    this.log.debug((Object)"optimistic locking: read strategy");
                } else {
                    strategyEl = MetaData.getOptionalChild((Element)element, (String)"version-column");
                    if (strategyEl != null) {
                        String fieldType = MetaData.getOptionalChildContent((Element)element, (String)"field-type");
                        if (fieldType != null) {
                            throw new DeploymentException("field-type is not allowed for version column. It is implicitly set to java.lang.Long.");
                        }
                        this.lockingStrategy = VERSION_COLUMN_STRATEGY;
                        this.lockingField = this.constructLockingField(entityMetaData, element);
                        this.groupName = null;
                        this.keyGeneratorFactory = null;
                        this.log.debug((Object)("optimistic locking: version-column=" + this.lockingField.getFieldName()));
                    } else {
                        strategyEl = MetaData.getOptionalChild((Element)element, (String)"timestamp-column");
                        if (strategyEl != null) {
                            String fieldType = MetaData.getOptionalChildContent((Element)element, (String)"field-type");
                            if (fieldType != null) {
                                throw new DeploymentException("field-type is not allowed for timestamp column. It is implicitly set to java.util.Date.");
                            }
                            this.lockingStrategy = TIMESTAMP_COLUMN_STRATEGY;
                            this.lockingField = this.constructLockingField(entityMetaData, element);
                            this.groupName = null;
                            this.keyGeneratorFactory = null;
                            this.log.debug((Object)("optimistic locking: timestamp-column=" + this.lockingField.getFieldName()));
                        } else {
                            this.keyGeneratorFactory = MetaData.getOptionalChildContent((Element)element, (String)"key-generator-factory");
                            if (this.keyGeneratorFactory != null) {
                                this.lockingStrategy = KEYGENERATOR_COLUMN_STRATEGY;
                                this.lockingField = this.constructLockingField(entityMetaData, element);
                                this.groupName = null;
                                this.log.debug((Object)("optimistic locking: key-generator-factory=" + this.keyGeneratorFactory));
                            } else {
                                throw new DeploymentException("Unexpected error: entity " + entityMetaData.getName() + " has unkown/incorrect optimistic locking configuration.");
                            }
                        }
                    }
                }
            }
        }
    }

    public Integer getLockingStrategy() {
        return this.lockingStrategy;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public JDBCCMPFieldMetaData getLockingField() {
        return this.lockingField;
    }

    public String getKeyGeneratorFactory() {
        return this.keyGeneratorFactory;
    }

    private JDBCCMPFieldMetaData constructLockingField(JDBCEntityMetaData entity, Element element) throws DeploymentException {
        String sqlType;
        int jdbcType;
        String jdbcTypeName;
        String columnName;
        String fieldName = MetaData.getOptionalChildContent((Element)element, (String)"field-name");
        if (fieldName == null || fieldName.trim().length() < 1) {
            String string = this.lockingStrategy == VERSION_COLUMN_STRATEGY ? "version_lock" : (fieldName = this.lockingStrategy == TIMESTAMP_COLUMN_STRATEGY ? "timestamp_lock" : "generated_lock");
        }
        if ((columnName = MetaData.getOptionalChildContent((Element)element, (String)"column-name")) == null || columnName.trim().length() < 1) {
            columnName = this.lockingStrategy == VERSION_COLUMN_STRATEGY ? "version_lock" : (this.lockingStrategy == TIMESTAMP_COLUMN_STRATEGY ? "timestamp_lock" : "generated_lock");
        }
        Class fieldType = null;
        if (this.lockingStrategy == VERSION_COLUMN_STRATEGY) {
            fieldType = Long.class;
        } else if (this.lockingStrategy == TIMESTAMP_COLUMN_STRATEGY) {
            fieldType = Date.class;
        }
        String fieldTypeStr = MetaData.getOptionalChildContent((Element)element, (String)"field-type");
        if (fieldTypeStr != null) {
            try {
                fieldType = GetTCLAction.getContextClassLoader().loadClass(fieldTypeStr);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load field type for optimistic locking field " + fieldName + ": " + fieldTypeStr);
            }
        }
        if ((jdbcTypeName = MetaData.getOptionalChildContent((Element)element, (String)"jdbc-type")) != null) {
            jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcTypeName);
            sqlType = MetaData.getUniqueChildContent((Element)element, (String)"sql-type");
        } else {
            jdbcType = Integer.MIN_VALUE;
            sqlType = null;
        }
        return new JDBCCMPFieldMetaData(entity, fieldName, fieldType, columnName, jdbcType, sqlType);
    }
}

