/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.services.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.services.rest.Util;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;

@Path(value="social/spaces")
public class SpacesRestService
implements ResourceContainer {
    private SpaceService _spaceService;

    private SpaceList showMySpaceList(String userId) {
        List mySpaces;
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        try {
            mySpaces = this._spaceService.getSpaces(userId);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(mySpaces);
        return spaceList;
    }

    private SpaceList showPendingSpaceList(String userId) {
        List pendingSpaces;
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        try {
            pendingSpaces = this._spaceService.getPendingSpaces(userId);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(pendingSpaces);
        return spaceList;
    }

    @GET
    @Path(value="{userId}/mySpaces/show.{format}")
    public Response showMySpaceList(@Context UriInfo uriInfo, @PathParam(value="userId") String userId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        SpaceList mySpaceList = this.showMySpaceList(userId);
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{userId}/pendingSpaces/show.{format}")
    public Response showPendingSpaceList(@Context UriInfo uriInfo, @PathParam(value="userId") String userId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        SpaceList pendingSpaceList = this.showPendingSpaceList(userId);
        return Util.getResponse(pendingSpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    private SpaceService getSpaceService() {
        if (this._spaceService == null) {
            PortalContainer portalContainer = PortalContainer.getInstance();
            this._spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        }
        return this._spaceService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class SpaceList {
        private List<Space> _spaces;

        public void setSpaces(List<Space> spaces) {
            this._spaces = spaces;
        }

        public List<Space> getSpaces() {
            return this._spaces;
        }

        public void addSpace(Space space) {
            if (this._spaces == null) {
                this._spaces = new ArrayList<Space>();
            }
            this._spaces.add(space);
        }
    }
}

