/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.composite;

import java.io.Serializable;
import java.util.Date;
import org.rhq.core.domain.measurement.AvailabilityType;

public class ResourceAvailabilitySummary
implements Serializable {
    long upTime;
    long downTime;
    int failures;
    long lastChange;
    AvailabilityType current;

    public ResourceAvailabilitySummary(long upTime, long downTime, int failures, long lastChange, AvailabilityType current) {
        this.upTime = upTime;
        this.downTime = downTime;
        this.failures = failures;
        this.lastChange = lastChange;
        this.current = current;
    }

    public long getMTBF() {
        return this.failures != 0 ? (this.upTime + this.downTime) / (long)this.failures : 0L;
    }

    public long getMTTR() {
        return this.failures != 0 ? this.downTime / (long)this.failures : 0L;
    }

    public double getUpPercentage() {
        return (double)this.upTime / (double)(this.upTime + this.downTime);
    }

    public long getUpTime() {
        return this.upTime;
    }

    public long getDownTime() {
        return this.downTime;
    }

    public int getFailures() {
        return this.failures;
    }

    public Date getLastChange() {
        return new Date(this.lastChange);
    }

    public AvailabilityType getCurrent() {
        return this.current;
    }
}

