/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activitystream;

import java.util.List;
import org.exoplatform.social.core.activitystream.JCRStorage;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.space.impl.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityManager {
    private JCRStorage storage;

    public ActivityManager(SocialDataLocation dataLocation) throws Exception {
        this.storage = new JCRStorage(dataLocation);
    }

    public Activity getActivity(String activityId) {
        return this.storage.load(activityId);
    }

    public void deleteActivity(String activityId) throws Exception {
        this.storage.deleteActivity(activityId);
    }

    public List<Activity> getActivities(Identity identity) throws Exception {
        String id = identity.getId();
        return this.storage.getActivities(id);
    }

    public Activity saveActivity(String identityId, Activity activity) throws Exception {
        if (identityId == null) {
            return null;
        }
        if (activity.getId() == null) {
            activity.setPostedTime(System.currentTimeMillis());
        }
        activity.setUpdated(System.currentTimeMillis());
        activity.setUserId(identityId);
        return this.storage.save(identityId, activity);
    }

    public Activity saveActivity(Activity activity) throws Exception {
        activity.setUpdated(System.currentTimeMillis());
        if (activity.getId() == null) {
            activity.setPostedTime(System.currentTimeMillis());
        }
        return this.storage.save(activity.getUserId(), activity);
    }

    public Activity recordActivity(String identityId, String type, String title, String body) throws Exception {
        Activity activity = new Activity(identityId, type, title, body);
        return this.saveActivity(identityId, activity);
    }
}

