/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import java.util.Collection;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;

public class CacheableMembershipHandlerImpl
implements MembershipHandler {
    private final ExoCache membershipCache;
    private final MembershipHandler membershipHandler;

    public CacheableMembershipHandlerImpl(OrganizationCacheHandler organizationCacheHandler, MembershipHandler membershipHandler) {
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.membershipHandler = membershipHandler;
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        this.membershipHandler.addMembershipEventListener(listener);
    }

    public void createMembership(Membership m, boolean broadcast) throws Exception {
        this.membershipHandler.createMembership(m, broadcast);
    }

    public Membership createMembershipInstance() {
        return this.membershipHandler.createMembershipInstance();
    }

    public Membership findMembership(String id) throws Exception {
        Membership membership = (Membership)this.membershipCache.get((Serializable)((Object)id));
        if (membership != null) {
            return membership;
        }
        membership = this.membershipHandler.findMembership(id);
        if (membership != null) {
            this.membershipCache.put((Serializable)((Object)membership.getId()), (Object)membership);
            this.membershipCache.put((Serializable)new MembershipCacheKey(membership), (Object)membership);
        }
        return membership;
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        Membership membership = (Membership)this.membershipCache.get((Serializable)new MembershipCacheKey(userName, groupId, type));
        if (membership != null) {
            return membership;
        }
        membership = this.membershipHandler.findMembershipByUserGroupAndType(userName, groupId, type);
        if (membership != null) {
            this.membershipCache.put((Serializable)((Object)membership.getId()), (Object)membership);
            this.membershipCache.put((Serializable)new MembershipCacheKey(membership), (Object)membership);
        }
        return membership;
    }

    public Collection findMembershipsByGroup(Group group) throws Exception {
        Collection memberships = this.membershipHandler.findMembershipsByGroup(group);
        for (Membership membership : memberships) {
            this.membershipCache.put((Serializable)((Object)membership.getId()), (Object)membership);
            this.membershipCache.put((Serializable)new MembershipCacheKey(membership), (Object)membership);
        }
        return memberships;
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        Collection memberships = this.membershipHandler.findMembershipsByUser(userName);
        for (Membership membership : memberships) {
            this.membershipCache.put((Serializable)((Object)membership.getId()), (Object)membership);
            this.membershipCache.put((Serializable)new MembershipCacheKey(membership), (Object)membership);
        }
        return memberships;
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        Collection memberships = this.membershipHandler.findMembershipsByUserAndGroup(userName, groupId);
        for (Membership membership : memberships) {
            this.membershipCache.put((Serializable)((Object)membership.getId()), (Object)membership);
            this.membershipCache.put((Serializable)new MembershipCacheKey(membership), (Object)membership);
        }
        return memberships;
    }

    public void linkMembership(User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        this.membershipHandler.linkMembership(user, group, m, broadcast);
    }

    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        Membership membership = this.membershipHandler.removeMembership(id, broadcast);
        if (membership != null) {
            this.membershipCache.remove((Serializable)((Object)membership.getId()));
            this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
        }
        return membership;
    }

    public Collection removeMembershipByUser(String username, boolean broadcast) throws Exception {
        Collection memberships = this.membershipHandler.removeMembershipByUser(username, broadcast);
        for (Membership membership : memberships) {
            this.membershipCache.remove((Serializable)((Object)membership.getId()));
            this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
        }
        return memberships;
    }
}

