/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.varia.scheduler.AbstractScheduleProvider;
import org.jboss.varia.scheduler.XMLScheduleProviderMBean;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLScheduleProvider
extends AbstractScheduleProvider
implements XMLScheduleProviderMBean {
    private Element mSchedules;
    private ArrayList mIDList = new ArrayList();

    public Element getSchedules() {
        return this.mSchedules;
    }

    public void setSchedules(Element pSchedules) {
        this.mSchedules = pSchedules;
    }

    public void startProviding() throws Exception {
        try {
            NodeList lSchedules = this.mSchedules.getElementsByTagName("schedule");
            for (int i = 0; i < lSchedules.getLength(); ++i) {
                Node lSchedule = lSchedules.item(i);
                NodeList lAttributes = lSchedule.getChildNodes();
                Text lItem = this.getNode(lAttributes, "target-mbean-name");
                if (lItem == null) {
                    this.log.error((Object)"No 'target-mbean-name' is specified therefore this Schedule is ignored");
                    continue;
                }
                this.log.info((Object)("Got 'target-mbean-name' element: " + lItem + ", node value: " + lItem.getData() + lItem.getChildNodes()));
                String lTarget = lItem.getData();
                lItem = this.getNode(lAttributes, "target-method-name");
                if (lItem == null) {
                    this.log.error((Object)"No 'target-method-name' is specified therefore this Schedule is ignored");
                    continue;
                }
                String lMethodName = lItem.getData();
                lItem = this.getNode(lAttributes, "target-method-signature");
                if (lItem == null) {
                    this.log.error((Object)"No 'target-method-signature' is specified therefore this Schedule is ignored");
                    continue;
                }
                String lMethodSignature = lItem.getData();
                lItem = this.getNode(lAttributes, "date-format");
                String dateFormat = null;
                if (lItem != null && (dateFormat = lItem.getData()) != null && dateFormat.trim().length() != 0) {
                    try {
                        new SimpleDateFormat(dateFormat);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Invalid date format therefore this Schedule is ignored", (Throwable)e);
                        continue;
                    }
                }
                if ((lItem = this.getNode(lAttributes, "start-date")) == null) {
                    this.log.error((Object)"No 'start-date' is specified therefore this Schedule is ignored");
                    continue;
                }
                String lStartDate = lItem.getData();
                lItem = this.getNode(lAttributes, "period");
                if (lItem == null) {
                    this.log.error((Object)"No 'period' is specified therefore this Schedule is ignored");
                    continue;
                }
                String lPeriod = lItem.getData();
                lItem = this.getNode(lAttributes, "repetitions");
                if (lItem == null) {
                    this.log.error((Object)"No 'repetitions' is specified therefore this Schedule is ignored");
                    continue;
                }
                String lRepeptions = lItem.getData();
                try {
                    int lID = this.addSchedule(new ObjectName(lTarget), lMethodName, this.getSignature(lMethodSignature), this.getStartDate(lStartDate, dateFormat), new Long(lPeriod), new Integer(lRepeptions));
                    this.mIDList.add(new Integer(lID));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    this.log.error((Object)"Could not convert a number", (Throwable)nfe);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected Text getNode(NodeList pList, String pName) {
        if (pList == null) {
            return null;
        }
        block3: for (int i = 0; i < pList.getLength(); ++i) {
            Node lNode = pList.item(i);
            switch (lNode.getNodeType()) {
                case 1: {
                    Element lChild = (Element)lNode;
                    if (!lChild.getNodeName().equals(pName)) continue block3;
                    return (Text)lChild.getFirstChild();
                }
            }
        }
        return null;
    }

    public void stopProviding() {
        for (Integer lID : this.mIDList) {
            try {
                this.removeSchedule(lID);
            }
            catch (JMException jme) {
                this.log.error((Object)"Could not remove Schedule in stop providing", (Throwable)jme);
            }
        }
    }

    protected String[] getSignature(String pMethodSignature) {
        if (pMethodSignature == null || "".equals(pMethodSignature.trim())) {
            return new String[0];
        }
        StringTokenizer lTokenizer = new StringTokenizer(pMethodSignature, ",");
        String[] lReturn = new String[lTokenizer.countTokens()];
        int i = 0;
        while (lTokenizer.hasMoreTokens()) {
            lReturn[i++] = lTokenizer.nextToken().trim();
        }
        return lReturn;
    }

    protected Date getStartDate(String pStartDate, String dateFormat) {
        pStartDate = pStartDate == null ? "" : pStartDate.trim();
        Date lReturn = null;
        if (pStartDate.equals("")) {
            lReturn = new Date(0L);
        } else if (pStartDate.equals("NOW")) {
            lReturn = new Date(new Date().getTime() + 1000L);
        } else {
            try {
                long lDate = new Long(pStartDate);
                lReturn = new Date(lDate);
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat dateFormatter = null;
                    dateFormatter = dateFormat == null || dateFormat.trim().length() == 0 ? new SimpleDateFormat() : new SimpleDateFormat(dateFormat);
                    lReturn = dateFormatter.parse(pStartDate);
                }
                catch (Exception e2) {
                    this.log.error((Object)("Could not parse given date string: " + pStartDate), (Throwable)e2);
                    throw new InvalidParameterException("Schedulable Date is not of correct format");
                }
            }
        }
        this.log.debug((Object)("Initial Start Date is set to: " + lReturn));
        return lReturn;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) throws MalformedObjectNameException {
        return pName == null ? XMLScheduleProviderMBean.OBJECT_NAME : pName;
    }
}

