/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.managed;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.services.binding.ServiceBindingMetadata;
import org.jboss.services.binding.impl.ServiceBindingSet;
import org.jboss.services.binding.managed.ServiceBindingMetadataMapper;
import org.jboss.services.binding.managed.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingSetMapper
extends MetaMapper<Set<ServiceBindingSet>> {
    private static final Logger log = Logger.getLogger(ServiceBindingSetMapper.class);
    public static final CollectionMetaType TYPE;
    public static final CompositeMetaType SERVICE_BINDING_SET_TYPE;

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return Set.class;
    }

    public MetaValue createMetaValue(MetaType metaType, Set<ServiceBindingSet> object) {
        ServiceBindingMetadataMapper mapper = new ServiceBindingMetadataMapper();
        TreeSet<CompositeValue> tmp = new TreeSet<CompositeValue>(new NameComparator());
        for (ServiceBindingSet b : object) {
            try {
                MapCompositeValueSupport cvs = new MapCompositeValueSupport((MetaType)SERVICE_BINDING_SET_TYPE);
                cvs.put("name", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getName())));
                cvs.put("defaultHostName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getDefaultHostName())));
                cvs.put("portOffset", (MetaValue)SimpleValueSupport.wrap((int)b.getPortOffset()));
                Set<ServiceBindingMetadata> metadata = b.getOverrideBindings();
                if (metadata != null) {
                    cvs.put("overrideBindings", mapper.createMetaValue(mapper.getMetaType(), metadata));
                }
                tmp.add((CompositeValue)cvs);
            }
            catch (Exception e) {
                log.warn((Object)("Skipping binding: " + b), (Throwable)e);
            }
        }
        MetaValue[] elements = tmp.toArray(new MetaValue[tmp.size()]);
        CollectionValueSupport bindings = new CollectionValueSupport(TYPE, elements);
        return bindings;
    }

    public Set<ServiceBindingSet> unwrapMetaValue(MetaValue metaValue) {
        if (metaValue == null) {
            return null;
        }
        if (!(metaValue instanceof CollectionValue)) {
            throw new IllegalArgumentException(metaValue + " is not a " + CollectionValue.class.getSimpleName());
        }
        CollectionValue collValue = (CollectionValue)metaValue;
        MetaValue[] elements = collValue.getElements();
        ServiceBindingMetadataMapper mapper = new ServiceBindingMetadataMapper();
        HashSet<ServiceBindingSet> result = new HashSet<ServiceBindingSet>(elements.length);
        for (MetaValue element : elements) {
            if (!(element instanceof CompositeValue)) {
                throw new IllegalArgumentException(element + " is not a " + CompositeValue.class.getSimpleName());
            }
            CompositeValue compValue = (CompositeValue)element;
            String name = Util.getValueFromComposite(compValue, "name", String.class);
            String defaultHostName = Util.getValueFromComposite(compValue, "defaultHostName", String.class);
            Integer portOffset = Util.getValueFromComposite(compValue, "portOffset", Integer.class);
            if (portOffset == null) {
                throw new IllegalStateException(element + " has no value for key 'port'");
            }
            Object overrides = mapper.unwrapMetaValue(compValue.get("overrideBindings"));
            ServiceBindingSet sbs = new ServiceBindingSet(name, defaultHostName, portOffset, (Set<ServiceBindingMetadata>)overrides);
            result.add(sbs);
        }
        return result;
    }

    static {
        String[] itemNames = new String[]{"name", "defaultHostName", "portOffset", "overrideBindings"};
        String[] itemDescriptions = new String[]{"the name of the binding set", "the host name that should be used for all bindings whose configuration does not specify fixedHostName=\"true\"", "value to add to the port configuration for a standard binding to derive the port to use in this binding set", "binding configurations that apply only to this binding set, either non-standard bindings or ones that override standard binding configurations"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.INTEGER_PRIMITIVE, ServiceBindingMetadataMapper.TYPE};
        SERVICE_BINDING_SET_TYPE = new ImmutableCompositeMetaType(ServiceBindingSet.class.getName(), "Service Binding Set", itemNames, itemDescriptions, itemTypes);
        TYPE = new CollectionMetaType(Set.class.getName(), (MetaType)SERVICE_BINDING_SET_TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameComparator
    implements Comparator<CompositeValue> {
        private NameComparator() {
        }

        @Override
        public int compare(CompositeValue o1, CompositeValue o2) {
            SimpleValue sv1 = (SimpleValue)o1.get("name");
            if (sv1 == null) {
                throw new IllegalStateException(o1 + " has no name");
            }
            SimpleValue sv2 = (SimpleValue)o2.get("name");
            if (sv2 == null) {
                throw new IllegalStateException(o2 + " has no name");
            }
            String name1 = (String)((Object)sv1.getValue());
            String name2 = (String)((Object)sv2.getValue());
            return name1.compareTo(name2);
        }
    }
}

