/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.util.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import org.jboss.ws.WSException;
import org.jboss.wsf.common.IOUtils;

public final class BufferedStreamSource
extends StreamSource {
    private byte[] bytes;
    private char[] chars;

    public BufferedStreamSource(StreamSource source) {
        try {
            InputStream sourceInputStream = source.getInputStream();
            if (sourceInputStream != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                IOUtils.copyStream((OutputStream)baos, (InputStream)sourceInputStream);
                this.bytes = baos.toByteArray();
            }
            Reader sourceReader = source.getReader();
            if (sourceInputStream == null && sourceReader != null) {
                char[] buffer = new char[1024];
                CharArrayWriter charArrayWriter = new CharArrayWriter(buffer.length);
                int countOfReadChars = sourceReader.read(buffer);
                while (countOfReadChars > 0) {
                    charArrayWriter.write(buffer, 0, countOfReadChars);
                    countOfReadChars = sourceReader.read(buffer);
                }
                this.chars = charArrayWriter.toCharArray();
            }
        }
        catch (IOException ex) {
            WSException.rethrow(ex);
        }
    }

    public BufferedStreamSource(byte[] bytes) {
        this.bytes = bytes;
    }

    public final InputStream getInputStream() {
        return this.bytes != null ? new ByteArrayInputStream(this.bytes) : null;
    }

    public final Reader getReader() {
        return this.chars != null ? new CharArrayReader(this.chars) : null;
    }

    public final String toString() {
        String retVal = null;
        if (this.bytes != null) {
            try {
                retVal = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                WSException.rethrow(e);
            }
        } else if (this.chars != null) {
            retVal = new String(this.chars);
        }
        return "" + retVal;
    }

    public final void setInputStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public final void setReader(Reader reader) {
        throw new UnsupportedOperationException();
    }
}

