/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample;

import com.google.common.collect.ImmutableSet;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.shindig.social.core.config.SocialApiGuiceModule;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.sample.oauth.SampleOAuthDataStore;
import org.apache.shindig.social.sample.oauth.SampleRealm;
import org.apache.shindig.social.sample.service.SampleContainerHandler;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleModule
extends SocialApiGuiceModule {
    @Override
    protected void configure() {
        super.configure();
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.canonical.json.db")).toInstance((Object)"sampledata/canonicaldb.json");
        this.bind(ActivityService.class).to(JsonDbOpensocialService.class);
        this.bind(AppDataService.class).to(JsonDbOpensocialService.class);
        this.bind(PersonService.class).to(JsonDbOpensocialService.class);
        this.bind(OAuthDataStore.class).to(SampleOAuthDataStore.class);
        this.requestStaticInjection(new Class[]{SampleRealm.class});
    }

    @Override
    protected Set<Object> getHandlers() {
        ImmutableSet.Builder handlers = ImmutableSet.builder();
        handlers.addAll(super.getHandlers());
        handlers.add(SampleContainerHandler.class);
        return handlers.build();
    }
}

