/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.api;

import java.util.Collection;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.RelationshipManagerFeaturesDescription;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RelationshipManager {
    public IdentitySession getIdentitySession();

    public RelationshipManagerFeaturesDescription getFeaturesDescription();

    public IdentitySearchCriteria createIdentitySearchCriteria();

    public void associateGroups(Collection<Group> var1, Collection<Group> var2) throws IdentityException;

    public void associateGroups(Group var1, Collection<Group> var2) throws IdentityException;

    public void associateGroupsByKeys(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void associateGroupsByKeys(String var1, Collection<String> var2) throws IdentityException;

    public void associateGroups(Group var1, Group var2) throws IdentityException;

    public void associateGroupsByKeys(String var1, String var2) throws IdentityException;

    public void associateUsers(Collection<Group> var1, Collection<User> var2) throws IdentityException;

    public void associateUser(Group var1, Collection<User> var2) throws IdentityException;

    public void associateUsersByKeys(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void associateUsersByKeys(String var1, Collection<String> var2) throws IdentityException;

    public void associateUser(Group var1, User var2) throws IdentityException;

    public void associateUserByKeys(String var1, String var2) throws IdentityException;

    public void disassociateGroups(User var1) throws IdentityException;

    public void disassociateGroups(String var1) throws IdentityException;

    public void disassociateGroups(Collection<Group> var1, Collection<Group> var2) throws IdentityException;

    public void disassociateGroups(Group var1, Collection<Group> var2) throws IdentityException;

    public void disassociateGroupsByKeys(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void disassociateGroupsByKeys(String var1, Collection<String> var2) throws IdentityException;

    public void disassociateUsers(Collection<Group> var1, Collection<User> var2) throws IdentityException;

    public void disassociateUsers(Group var1, Collection<User> var2) throws IdentityException;

    public void disassociateUsersByKeys(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void disassociateUsersByKeys(String var1, Collection<String> var2) throws IdentityException;

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(Collection<G> var1, Collection<I> var2) throws IdentityException;

    public boolean isAssociatedByKeys(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(G var1, I var2) throws IdentityException;

    public boolean isAssociatedByKeys(String var1, String var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(Group var1, String var2, boolean var3, boolean var4) throws IdentityException;

    public Collection<Group> findAssociatedGroups(Group var1, String var2, boolean var3, boolean var4, IdentitySearchCriteria var5) throws IdentityException;

    public Collection<Group> findAssociatedGroups(String var1, String var2, boolean var3, boolean var4, IdentitySearchCriteria var5) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1, String var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findAssociatedGroups(String var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(String var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1) throws IdentityException;

    public Collection<User> findAssociatedUsers(Group var1, boolean var2) throws IdentityException;

    public Collection<User> findAssociatedUsers(Group var1, boolean var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<User> findAssociatedUsers(String var1, boolean var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findRelatedGroups(User var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findRelatedGroups(String var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<User> findRelatedUsers(Group var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<User> findRelatedUsers(String var1, IdentitySearchCriteria var2) throws IdentityException;
}

