/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.InputStream;
import org.hibernate.util.DTDEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class EJB3DTDEntityResolver
extends DTDEntityResolver {
    public static final EntityResolver INSTANCE = new EJB3DTDEntityResolver();
    private final Logger log = LoggerFactory.getLogger(EJB3DTDEntityResolver.class);
    boolean resolved = false;

    public boolean isResolved() {
        return this.resolved;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource is = super.resolveEntity(publicId, systemId);
        if (is != null) {
            this.resolved = true;
            return is;
        }
        if (systemId == null) return null;
        if (systemId.endsWith("orm_1_0.xsd")) {
            this.log.debug("recognized EJB3 ORM namespace; attempting to resolve on classpath under org/hibernate/ejb");
            String path = "org/hibernate/ejb/orm_1_0.xsd";
            InputStream dtdStream = this.resolveInHibernateNamespace(path);
            if (dtdStream == null) {
                this.log.debug("unable to locate [{}] on classpath", (Object)systemId);
                return null;
            }
            this.log.debug("located [{}] in classpath", (Object)systemId);
            InputSource source = new InputSource(dtdStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            this.resolved = false;
            return source;
        }
        if (!systemId.endsWith("persistence_1_0.xsd")) return null;
        this.log.debug("recognized EJB3 ORM namespace; attempting to resolve on classpath under org/hibernate/ejb");
        String path = "org/hibernate/ejb/persistence_1_0.xsd";
        InputStream dtdStream = this.resolveInHibernateNamespace(path);
        if (dtdStream == null) {
            this.log.debug("unable to locate [{}] on classpath", (Object)systemId);
            return null;
        }
        this.log.debug("located [{}] in classpath", (Object)systemId);
        InputSource source = new InputSource(dtdStream);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        this.resolved = true;
        return source;
    }
}

