/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributeDescription;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.api.CredentialType;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.SimpleCredentialType;
import org.picketlink.idm.impl.api.attribute.IdentityObjectAttributeMetaDataImpl;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.managers.AbstractManager;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesManagerImpl
extends AbstractManager
implements AttributesManager,
Serializable {
    private static final long serialVersionUID = 1285532201632609092L;

    public AttributesManagerImpl(IdentitySessionImpl session) {
        super(session);
    }

    public AttributeDescription getAttributeDescription(IdentityType identityType, String name) {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(name, "Attribute name");
        Map mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        if (mdMap != null && mdMap.containsKey(name)) {
            IdentityObjectAttributeMetaData attributeMD = (IdentityObjectAttributeMetaData)mdMap.get(name);
            if (attributeMD instanceof AttributeDescription) {
                return (AttributeDescription)attributeMD;
            }
            return new IdentityObjectAttributeMetaDataImpl(attributeMD);
        }
        return null;
    }

    public AttributeDescription getAttributeDescription(String id, String attributeName) {
        this.checkNotNullArgument(id, "IdentityType Id");
        this.checkNotNullArgument(attributeName, "Attribute name");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttributeDescription(identityType, attributeName);
    }

    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(IdentityType identityType) {
        this.checkNotNullArgument(identityType, "IdentityType");
        Map mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        HashMap<String, AttributeDescription> descriptionMap = new HashMap<String, AttributeDescription>();
        if (mdMap != null) {
            for (IdentityObjectAttributeMetaData attributeMD : mdMap.values()) {
                if (attributeMD instanceof AttributeDescription) {
                    descriptionMap.put(attributeMD.getName(), (AttributeDescription)attributeMD);
                    continue;
                }
                descriptionMap.put(attributeMD.getName(), new IdentityObjectAttributeMetaDataImpl(attributeMD));
            }
        }
        return descriptionMap;
    }

    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(String id) {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getSupportedAttributesDescriptions(identityType);
    }

    public Set<String> getSupportedAttributeNames(IdentityType identityType) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        return this.getRepository().getSupportedAttributeNames(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
    }

    public Set<String> getSupportedAttributeNames(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getSupportedAttributeNames(identityType);
    }

    public Map<String, Attribute> getAttributes(IdentityType identityType) throws IdentityException {
        Map attributes;
        this.checkNotNullArgument(identityType, "IdentityType");
        if (this.cache != null && (attributes = this.cache.getAttributes(this.cacheNS, identityType.getKey())) != null) {
            return attributes;
        }
        Map map = this.getRepository().getAttributes(this.getInvocationContext(), this.createIdentityObject(identityType));
        HashMap<String, Attribute> newMap = new HashMap<String, Attribute>();
        for (Map.Entry entry : map.entrySet()) {
            newMap.put((String)entry.getKey(), this.convertAttribute((IdentityObjectAttribute)entry.getValue()));
        }
        if (this.cache != null) {
            this.cache.putAttributes(this.cacheNS, identityType.getKey(), newMap);
        }
        return newMap;
    }

    public Map<String, Attribute> getAttributes(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttributes(identityType);
    }

    public void updateAttributes(IdentityType identity, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributes, "Attributes");
        this.preAttributesUpdate(identity, attributes);
        this.getRepository().updateAttributes(this.getInvocationContext(), this.createIdentityObject(identity), this.convertAttributes(attributes));
        if (this.cache != null) {
            this.cache.invalidateAttributes(this.cacheNS, identity.getKey());
            this.getAttributes(identity);
        }
        this.postAttributesUpdate(identity, attributes);
    }

    public void updateAttributes(String id, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributes, "Attributes");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.updateAttributes(identityType, attributes);
    }

    public Attribute getAttribute(IdentityType identityType, String attributeName) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        return this.getAttributes(identityType).get(attributeName);
    }

    public Attribute getAttribute(String id, String attributeName) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttribute(identityType, attributeName);
    }

    public void addAttribute(IdentityType identityType, String attributeName, Object[] values) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(values, "Attribute values");
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, values)};
        this.addAttributes(identityType, attrs);
    }

    public void addAttributes(String id, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributes, "Attributes");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttributes(identityType, attributes);
    }

    public void addAttribute(IdentityType identityType, String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, value)};
        this.addAttributes(identityType, attrs);
    }

    public void addAttribute(String id, String attributeName, Object[] values) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(values, "Attribute values");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttribute(identityType, attributeName, values);
    }

    public void addAttribute(String id, String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttribute(identityType, attributeName, value);
    }

    public void addAttributes(IdentityType identityType, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributes, "Attributes");
        this.preAttributesAdd(identityType, attributes);
        this.getRepository().addAttributes(this.getInvocationContext(), this.createIdentityObject(identityType), this.convertAttributes(attributes));
        if (this.cache != null) {
            this.cache.invalidateAttributes(this.cacheNS, identityType.getKey());
            this.getAttributes(identityType);
        }
        this.postAttributesAdd(identityType, attributes);
    }

    public void removeAttributes(IdentityType identityType, String[] attributeNames) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeNames, "Attribute names");
        this.preAttributesRemove(identityType, attributeNames);
        this.getRepository().removeAttributes(this.getInvocationContext(), this.createIdentityObject(identityType), attributeNames);
        if (this.cache != null) {
            this.cache.invalidateAttributes(this.cacheNS, identityType.getKey());
            this.getAttributes(identityType);
        }
        this.postAttributesRemove(identityType, attributeNames);
    }

    public void removeAttributes(String id, String[] attributeNames) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeNames, "Attribute names");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.removeAttributes(identityType, attributeNames);
    }

    public boolean hasPassword(User user) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.createIdentityObject(user).getIdentityType(), (IdentityObjectCredentialType)PasswordCredential.TYPE);
    }

    public boolean validatePassword(User user, String password) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(password, "Password");
        return this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(user), (IdentityObjectCredential)new PasswordCredential(password));
    }

    public void updatePassword(User user, String password) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(password, "Password");
        this.preCredentialUpdate(user, new PasswordCredential(password));
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(user), (IdentityObjectCredential)new PasswordCredential(password));
        this.postCredentialUpdate(user, new PasswordCredential(password));
    }

    public boolean isCredentialTypeSupported(CredentialType credentialType) throws IdentityException {
        this.checkNotNullArgument(credentialType, "CredentialType");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.getUserObjectType(), (IdentityObjectCredentialType)new SimpleCredentialType(credentialType.getName()));
    }

    public boolean validateCredentials(User user, Credential[] credentials) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(credentials, "Credentials");
        for (Credential credential : credentials) {
            IdentityObjectCredential ioc = null;
            if (!(credential instanceof IdentityObjectCredential)) {
                throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
            }
            ioc = (IdentityObjectCredential)credential;
            if (this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(user), ioc)) continue;
            return false;
        }
        return true;
    }

    public void updateCredential(User user, Credential credential) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(credential, "Credential");
        if (!(credential instanceof IdentityObjectCredential)) {
            throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
        }
        this.preCredentialUpdate(user, credential);
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(user), (IdentityObjectCredential)credential);
        this.postCredentialUpdate(user, credential);
    }

    public User findUserByUniqueAttribute(String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        IdentityObject io = this.getRepository().findIdentityObjectByUniqueAttribute(this.getInvocationContext(), this.getUserObjectType(), (IdentityObjectAttribute)new SimpleAttribute(attributeName, value));
        if (io == null) {
            return null;
        }
        return this.createUser(io);
    }

    public Group findGroupByUniqueAttribute(String groupType, String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(groupType, "GroupType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        IdentityObject io = this.getRepository().findIdentityObjectByUniqueAttribute(this.getInvocationContext(), this.getIdentityObjectType(groupType), (IdentityObjectAttribute)new SimpleAttribute(attributeName, value));
        if (io == null) {
            return null;
        }
        return this.createGroup(io);
    }
}

