/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.initializer.impl;

import java.io.IOException;
import java.net.URL;
import org.exoplatform.common.http.client.AuthorizationHandler;
import org.exoplatform.common.http.client.AuthorizationInfo;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.services.jcr.ext.initializer.RemoteWorkspaceInitializationException;

public class RemoteHttpClient {
    private static final int HTTP_OK = 200;
    private final String dataSourceUrl;

    public RemoteHttpClient(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    public String execute(String repositoryName, String workspaceName, String id) throws RemoteWorkspaceInitializationException {
        String result = "FAIL";
        try {
            String complURL = this.dataSourceUrl + "/rest/jcr-remote-workspace-initializer" + "/" + repositoryName + "/" + workspaceName + "/" + id + "/" + "getWorkspaceData";
            URL url = new URL(complURL);
            String userInfo = url.getUserInfo();
            if (userInfo == null || userInfo.split(":").length != 2) {
                throw new RemoteWorkspaceInitializationException("Fail remote initializetion : the user name or password not not specified : " + this.dataSourceUrl);
            }
            String userName = userInfo.split(":")[0];
            String password = userInfo.split(":")[1];
            HTTPConnection connection = new HTTPConnection(url);
            connection.removeModule(CookieModule.class);
            String realmName = this.getRealm(complURL);
            connection.addBasicAuthorization(realmName, userName, password);
            HTTPResponse resp = connection.Get(url.getFile());
            result = resp.getText();
            AuthorizationInfo.removeAuthorization((String)url.getHost(), (int)url.getPort(), (String)"Basic", (String)realmName);
            if (resp.getStatusCode() != 200) {
                throw new RemoteWorkspaceInitializationException("Fail remote initializetion : " + result);
            }
        }
        catch (ModuleException e) {
            throw new RemoteWorkspaceInitializationException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new RemoteWorkspaceInitializationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RemoteWorkspaceInitializationException(e.getMessage(), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRealm(String sUrl) throws IOException, ModuleException {
        AuthorizationHandler ah = AuthorizationInfo.getAuthHandler();
        try {
            URL url = new URL(sUrl);
            HTTPConnection connection = new HTTPConnection(url);
            connection.removeModule(CookieModule.class);
            AuthorizationInfo.setAuthHandler(null);
            HTTPResponse resp = connection.Get(url.getFile());
            String authHeader = resp.getHeader("WWW-Authenticate");
            String realm = authHeader.split("=")[1];
            String string = realm = realm.substring(1, realm.length() - 1);
            return string;
        }
        finally {
            AuthorizationInfo.setAuthHandler((AuthorizationHandler)ah);
        }
    }
}

