/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import groovy.lang.Writable;
import groovy.text.Template;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.groovyscript.GroovyTemplate;
import org.exoplatform.groovyscript.GroovyTemplateEngine;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.groovyscript.text.TemplateStatistic;
import org.exoplatform.groovyscript.text.TemplateStatisticService;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="management"), @Property(key="type", value="template")})
@ManagedDescription(value="Template management service")
@RESTEndpoint(path="templateservice")
public class TemplateService {
    private GroovyTemplateEngine engine_ = new GroovyTemplateEngine();
    private ExoCache<String, GroovyTemplate> templatesCache_;
    private TemplateStatisticService statisticService;
    private boolean cacheTemplate_ = true;

    public TemplateService(TemplateStatisticService statisticService, CacheService cservice) throws Exception {
        this.statisticService = statisticService;
        this.templatesCache_ = cservice.getCacheInstance(TemplateService.class.getSimpleName());
    }

    public void merge(String name, BindingContext context) throws Exception {
        long startTime = System.currentTimeMillis();
        GroovyTemplate template = this.getTemplate(name, context.getResourceResolver());
        context.put("_ctx", context);
        context.setGroovyTemplateService(this);
        template.render(context.getWriter(), context);
        long endTime = System.currentTimeMillis();
        TemplateStatistic templateStatistic = this.statisticService.getTemplateStatistic(name);
        templateStatistic.setTime(endTime - startTime);
        templateStatistic.setResolver(context.getResourceResolver());
    }

    @Deprecated
    public void merge(Template template, BindingContext context) throws Exception {
        context.put("_ctx", context);
        context.setGroovyTemplateService(this);
        Writable writable = template.make((Map)context);
        writable.writeTo(context.getWriter());
    }

    public void include(String name, BindingContext context) throws Exception {
        if (context == null) {
            throw new Exception("Binding cannot be null");
        }
        context.put("_ctx", context);
        GroovyTemplate template = this.getTemplate(name, context.getResourceResolver());
        template.render(context.getWriter(), context);
    }

    public final GroovyTemplate getTemplate(String name, ResourceResolver resolver) throws Exception {
        return this.getTemplate(name, resolver, this.cacheTemplate_);
    }

    public final GroovyTemplate getTemplate(String url, ResourceResolver resolver, boolean cacheable) throws Exception {
        GroovyTemplate template = null;
        if (cacheable) {
            String resourceId = resolver.createResourceId(url);
            template = (GroovyTemplate)this.getTemplatesCache().get((Serializable)((Object)resourceId));
        }
        if (template != null) {
            return template;
        }
        byte[] bytes = null;
        InputStream is = resolver.getInputStream(url);
        bytes = IOUtil.getStreamContentAsBytes((InputStream)is);
        is.close();
        int pos = url.lastIndexOf(47);
        if (pos == -1) {
            pos = 0;
        }
        String name = url.substring(pos);
        String text = new String(bytes);
        template = this.engine_.createTemplate(url, name, text);
        if (cacheable) {
            String resourceId = resolver.createResourceId(url);
            this.getTemplatesCache().put((Serializable)((Object)resourceId), (Object)template);
        }
        return template;
    }

    public final void invalidateTemplate(String name, ResourceResolver resolver) throws Exception {
        String resourceId = resolver.createResourceId(name);
        this.getTemplatesCache().remove((Serializable)((Object)resourceId));
    }

    public ExoCache<String, GroovyTemplate> getTemplatesCache() {
        return this.templatesCache_;
    }

    @Managed
    @ManagedDescription(value="Clear the template cache")
    public void reloadTemplates() {
        try {
            this.templatesCache_.clearCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Managed
    @ManagedDescription(value="Clear the template cache for a specified template identifier")
    @Impact(value=ImpactType.IDEMPOTENT_WRITE)
    public void reloadTemplate(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        try {
            TemplateStatistic app = this.statisticService.apps.get(name);
            ResourceResolver resolver = app.getResolver();
            this.templatesCache_.remove((Serializable)((Object)resolver.createResourceId(name)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Managed
    @ManagedDescription(value="List the identifiers of the cached templates")
    @Impact(value=ImpactType.READ)
    public String[] listCachedTemplates() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (GroovyTemplate template : this.templatesCache_.getCachedObjects()) {
                list.add(template.getId());
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

