/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

public class ReplicateDeliveryMessage
extends ClusterRequest {
    private int nodeID;
    private String queueName;
    private String sessionID;
    private long messageID;
    private long deliveryID;
    private Address returnAddress;

    public ReplicateDeliveryMessage() {
    }

    public ReplicateDeliveryMessage(int nodeID, String queueName, String sessionID, long messageID, long deliveryID, Address returnAddress) {
        this.nodeID = nodeID;
        this.queueName = queueName;
        this.sessionID = sessionID;
        this.messageID = messageID;
        this.deliveryID = deliveryID;
        this.returnAddress = returnAddress;
    }

    Object execute(RequestTarget office) throws Throwable {
        office.handleReplicateDelivery(this.nodeID, this.queueName, this.sessionID, this.messageID, this.deliveryID, this.returnAddress);
        return null;
    }

    byte getType() {
        return 8;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeID = in.readInt();
        this.queueName = in.readUTF();
        this.sessionID = in.readUTF();
        this.messageID = in.readLong();
        this.deliveryID = in.readLong();
        byte b = in.readByte();
        if (b != 0) {
            this.returnAddress = new IpAddress();
            this.returnAddress.readFrom(in);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeID);
        out.writeUTF(this.queueName);
        out.writeUTF(this.sessionID);
        out.writeLong(this.messageID);
        out.writeLong(this.deliveryID);
        if (this.returnAddress == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (!(this.returnAddress instanceof IpAddress)) {
                throw new IllegalStateException("Address must be IpAddress");
            }
            this.returnAddress.writeTo(out);
        }
    }
}

