/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.ajax4jsf.io.ByteBuffer;
import org.ajax4jsf.io.CharBuffer;
import org.ajax4jsf.io.FastBufferWriter;

public class FastBufferOutputStream
extends OutputStream {
    ByteBuffer firstBuffer;
    ByteBuffer lastBuffer;
    int length;

    public FastBufferOutputStream() {
        this(256);
    }

    public FastBufferOutputStream(int initialSize) {
        this(new ByteBuffer(initialSize));
    }

    public FastBufferOutputStream(ByteBuffer firstBuffer) {
        this.firstBuffer = firstBuffer;
        this.lastBuffer = firstBuffer;
    }

    public void write(int c) throws IOException {
        this.lastBuffer = this.lastBuffer.append((byte)c);
        ++this.length;
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        int limit = b.length;
        this.length += limit;
        this.lastBuffer = this.lastBuffer.append(b, 0, limit);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.lastBuffer = this.lastBuffer.append(b, off, len);
        this.length += len;
    }

    public int getLength() {
        return this.length;
    }

    public ByteBuffer getFirstBuffer() {
        return this.firstBuffer;
    }

    public byte[] toByteArray() {
        ByteBuffer b = this.getFirstBuffer();
        if (b == null) {
            return new byte[0];
        }
        ByteBuffer l = b;
        while (l.getNext() != null) {
            l = l.getNext();
        }
        byte[] result = new byte[l.getTotalSize()];
        int index = 0;
        while (b != null) {
            int s = b.getUsedSize();
            System.arraycopy(b.getBytes(), 0, result, index, s);
            index += s;
            b = b.getNext();
        }
        return result;
    }

    public void writeTo(OutputStream out) throws IOException {
        for (ByteBuffer b = this.getFirstBuffer(); b != null; b = b.getNext()) {
            out.write(b.getBytes(), 0, b.getUsedSize());
        }
    }

    public void writeTo(Writer out, String encoding) throws IOException {
        for (ByteBuffer b = this.getFirstBuffer(); b != null; b = b.getNext()) {
            CharBuffer c = b.toCharBuffer(encoding);
            out.write(c.getChars(), 0, c.getUsedSize());
        }
    }

    public FastBufferWriter convertToWriter(String encoding) throws UnsupportedEncodingException {
        CharBuffer first;
        ByteBuffer c = this.firstBuffer;
        CharBuffer b = first = c.toCharBuffer(encoding);
        while (c != null && (c = c.getNext()) != null) {
            CharBuffer n = c.toCharBuffer(encoding);
            b.setNext(n);
            b = n;
        }
        return new FastBufferWriter(first);
    }

    public FastBufferWriter convertToWriter() {
        CharBuffer first;
        ByteBuffer c = this.firstBuffer;
        CharBuffer b = first = c.toCharBuffer();
        while (c != null && (c = c.getNext()) != null) {
            CharBuffer n = c.toCharBuffer();
            b.setNext(n);
            b = n;
        }
        return new FastBufferWriter(first);
    }

    public void reset() {
        this.firstBuffer.reset();
        this.lastBuffer = this.firstBuffer;
        this.length = 0;
    }
}

