/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIPush;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.AjaxCommandRendererBase;
import org.ajax4jsf.renderkit.AjaxRendererUtils;

public class AjaxPushRenderer
extends AjaxCommandRendererBase {
    public static final String PUSH_INTERVAL_PARAMETER = "A4J.AJAX.Push.INTERVAL";
    public static final String PUSH_WAIT_PARAMETER = "A4J.AJAX.Push.WAIT";
    public static final String PUSH_URL_PARAMETER = "A4J.AJAX.Push.URL";
    public static final int DEFAULT_PUSH_INTERVAL = 1000;
    public static final int DEFAULT_PUSH_WAIT = Integer.MIN_VALUE;
    private static final String AJAX_PUSH_FUNCTION = "A4J.AJAX.Push";

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIPush push = (UIPush)component;
        writer.startElement("span", component);
        writer.writeAttribute("style", (Object)"display:none;", null);
        this.getUtils().encodeId(context, component);
        this.getUtils().encodeBeginFormIfNessesary(context, component);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer("\n");
        if (push.isEnabled()) {
            JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context, (String)AJAX_PUSH_FUNCTION);
            Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
            options.put("dummyForm", component.getClientId(context) + ":_form");
            int interval = push.getInterval();
            if (interval == Integer.MIN_VALUE) {
                String intervalInitParameter = context.getExternalContext().getInitParameter(PUSH_INTERVAL_PARAMETER);
                interval = null != intervalInitParameter ? Integer.parseInt(intervalInitParameter) : 1000;
            }
            options.put("pushinterval", new Integer(interval));
            options.put("pushId", push.getListenerId(context));
            String pushUrl = context.getExternalContext().getInitParameter(PUSH_URL_PARAMETER);
            if (null != pushUrl) {
                options.put("pushUrl", pushUrl);
            }
            function.addParameter((Object)options);
            function.appendScript(script);
        } else {
            script.append("A4J.AJAX.StopPush('").append(push.getListenerId(context)).append("')");
        }
        script.append(";\n");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
        this.getUtils().encodeEndFormIfNessesary(context, component);
        writer.endElement("span");
    }

    protected Class getComponentClass() {
        return UIPush.class;
    }

    protected boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        boolean submitted = super.isSubmitted(facesContext, uiComponent);
        UIPush push = (UIPush)uiComponent;
        push.setSubmitted(submitted);
        return submitted;
    }
}

