/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            SetAccessibleAction.NON_PRIVILEGED.setAccessible(accessibleObject);
        } else {
            SetAccessibleAction.PRIVILEGED.setAccessible(accessibleObject);
        }
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetClassLoaderAction {
        public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    static interface SetAccessibleAction {
        public static final SetAccessibleAction PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(final AccessibleObject accessibleObject) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            accessibleObject.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Error setting " + accessibleObject + " as accessible ", e.getException());
                }
            }
        };
        public static final SetAccessibleAction NON_PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(AccessibleObject accessibleObject) {
                accessibleObject.setAccessible(true);
            }
        };

        public void setAccessible(AccessibleObject var1);
    }
}

