/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.EvictionActionPolicy;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.lock.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog(BaseEvictionAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();
    protected EvictionActionPolicy evictionActionPolicy;
    protected EvictionAlgorithmConfig evictionAlgorithmConfig;
    protected BlockingQueue<Fqn> recycleQueue = new LinkedBlockingQueue<Fqn>(500000);
    protected EvictionQueue evictionQueue;
    protected boolean allowTombstones = false;
    protected Configuration configuration;
    protected Fqn regionFqn;
    protected CacheSPI<?, ?> cache;

    protected abstract EvictionQueue setupEvictionQueue() throws EvictionException;

    protected abstract boolean shouldEvictNode(NodeEntry var1);

    protected BaseEvictionAlgorithm() {
    }

    @Override
    public synchronized void initialize() {
        if (this.evictionQueue == null) {
            this.evictionQueue = this.setupEvictionQueue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized: " + this));
            }
            Configuration.CacheMode cm = this.configuration != null ? this.configuration.getCacheMode() : Configuration.CacheMode.LOCAL;
            this.allowTombstones = this.configuration != null && this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC && (cm == Configuration.CacheMode.INVALIDATION_ASYNC || cm == Configuration.CacheMode.INVALIDATION_SYNC);
        }
    }

    public EvictionActionPolicy getEvictionActionPolicy() {
        return this.evictionActionPolicy;
    }

    @Override
    public void setEvictionActionPolicy(EvictionActionPolicy evictionActionPolicy) {
        this.evictionActionPolicy = evictionActionPolicy;
    }

    public EvictionAlgorithmConfig getEvictionAlgorithmConfig() {
        return this.evictionAlgorithmConfig;
    }

    @Override
    public void assignToRegion(Fqn fqn, CacheSPI<?, ?> cache, EvictionAlgorithmConfig evictionAlgorithmConfig, Configuration configuration) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.getClass().getSimpleName() + " instantiated and assigned to region " + fqn + " with cfg " + evictionAlgorithmConfig));
        }
        this.regionFqn = fqn;
        this.cache = cache;
        this.evictionAlgorithmConfig = evictionAlgorithmConfig;
        this.configuration = configuration;
    }

    @Override
    public boolean canIgnoreEvent(EvictionEvent.Type eventType) {
        return false;
    }

    @Override
    public void process(BlockingQueue<EvictionEvent> eventQueue) throws EvictionException {
        if (trace) {
            log.trace((Object)("process(): region: " + this.regionFqn));
        }
        this.initialize();
        this.processQueues(eventQueue);
        this.emptyRecycleQueue();
        this.prune();
    }

    @Override
    public void resetEvictionQueue() {
    }

    @Override
    public EvictionQueue getEvictionQueue() {
        return this.evictionQueue;
    }

    protected EvictionEvent getNextInQueue(BlockingQueue<EvictionEvent> queue) {
        try {
            return queue.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected void processQueues(BlockingQueue<EvictionEvent> queue) throws EvictionException {
        EvictionEvent node;
        int count = 0;
        block9: while ((node = this.getNextInQueue(queue)) != null) {
            ++count;
            switch (node.getEventType()) {
                case ADD_NODE_EVENT: {
                    this.processAddedNodes(node);
                    continue block9;
                }
                case REMOVE_NODE_EVENT: {
                    this.processRemovedNodes(node);
                    continue block9;
                }
                case VISIT_NODE_EVENT: {
                    this.processVisitedNodes(node);
                    continue block9;
                }
                case ADD_ELEMENT_EVENT: {
                    this.processAddedElement(node);
                    continue block9;
                }
                case REMOVE_ELEMENT_EVENT: {
                    this.processRemovedElement(node);
                    continue block9;
                }
                case MARK_IN_USE_EVENT: {
                    this.processMarkInUseNodes(node.getFqn(), node.getInUseTimeout());
                    continue block9;
                }
                case UNMARK_USE_EVENT: {
                    this.processUnmarkInUseNodes(node.getFqn());
                    continue block9;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + (Object)((Object)node.getEventType()));
        }
        if (trace) {
            log.trace((Object)("processed " + count + " node events"));
        }
    }

    protected void evict(NodeEntry ne) {
        if (ne != null) {
            this.evictionQueue.removeNodeEntry(ne);
            if (!this.evictCacheNode(ne.getFqn())) {
                try {
                    boolean result = this.recycleQueue.offer(ne.getFqn(), 5L, TimeUnit.SECONDS);
                    if (!result) {
                        log.warn((Object)("Unable to add Fqn[" + ne.getFqn() + "] to recycle " + "queue because it's full. This is often sign that " + "evictions are not occurring and nodes that should be " + "evicted are piling up waiting to be evicted."));
                    }
                }
                catch (InterruptedException e) {
                    log.debug((Object)"InterruptedException", (Throwable)e);
                }
            }
        }
    }

    protected boolean evictCacheNode(Fqn fqn) {
        if (trace) {
            log.trace((Object)("Attempting to evict cache node with fqn of " + fqn));
        }
        try {
            this.evictionActionPolicy.evict(fqn);
        }
        catch (TimeoutException e) {
            log.warn((Object)("Eviction of " + fqn + " timed out, retrying later"));
            log.debug((Object)e, (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Eviction of " + fqn + " failed"), (Throwable)e);
            return false;
        }
        if (trace) {
            log.trace((Object)("Eviction of cache node with fqn of " + fqn + " successful"));
        }
        return true;
    }

    protected void processMarkInUseNodes(Fqn fqn, long inUseTimeout) throws EvictionException {
        NodeEntry ne;
        if (trace) {
            log.trace((Object)("Marking node " + fqn + " as in use with a usage timeout of " + inUseTimeout));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setCurrentlyInUse(true, inUseTimeout);
        }
    }

    protected void processUnmarkInUseNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne;
        if (trace) {
            log.trace((Object)("Unmarking node " + fqn + " as in use"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setCurrentlyInUse(false, 0L);
        }
    }

    protected void processAddedNodes(EvictionEvent evictedEventNode) throws EvictionException {
        this.processAddedNodes(evictedEventNode, evictedEventNode.getElementDifference());
    }

    protected void processAddedNodes(EvictionEvent evictedEventNode, int numAddedElements) throws EvictionException {
        NodeEntry ne;
        Fqn fqn = evictedEventNode.getFqn();
        if (trace) {
            log.trace((Object)("Adding node " + fqn + " with " + numAddedElements + " elements to eviction queue"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setModifiedTimeStamp(evictedEventNode.getCreationTimestamp());
            ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
            ne.setNumberOfElements(ne.getNumberOfElements() + numAddedElements);
            if (trace) {
                log.trace((Object)("Queue already contains " + ne.getFqn() + " processing it as visited"));
            }
            this.processVisitedNodes(evictedEventNode);
            return;
        }
        ne = new NodeEntry(fqn);
        ne.setModifiedTimeStamp(evictedEventNode.getCreationTimestamp());
        ne.setNumberOfNodeVisits(1);
        ne.setNumberOfElements(numAddedElements);
        this.evictionQueue.addNodeEntry(ne);
        if (trace) {
            log.trace((Object)(ne.getFqn() + " added successfully to eviction queue"));
        }
    }

    protected void processRemovedNodes(EvictionEvent evictedEventNode) throws EvictionException {
        NodeEntry ne;
        Fqn fqn = evictedEventNode.getFqn();
        if (trace) {
            log.trace((Object)("Removing node " + fqn + " from eviction queue and attempting eviction"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            if (this.allowTombstones) {
                return;
            }
        } else {
            if (trace) {
                log.trace((Object)("processRemoveNodes(): Can't find node associated with fqn: " + fqn + "Could have been evicted earlier. Will just continue."));
            }
            return;
        }
        this.evictionQueue.removeNodeEntry(ne);
        if (trace) {
            log.trace((Object)(fqn + " removed from eviction queue"));
        }
    }

    protected void processVisitedNodes(EvictionEvent evictedEventNode) throws EvictionException {
        Fqn fqn = evictedEventNode.getFqn();
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Visiting node that was not added to eviction queues. Assuming that it has 1 element.");
            }
            this.processAddedNodes(evictedEventNode, 1);
            return;
        }
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(evictedEventNode.getCreationTimestamp());
    }

    protected void processRemovedElement(EvictionEvent evictedEventNode) throws EvictionException {
        Fqn fqn = evictedEventNode.getFqn();
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing element from " + fqn + " but eviction queue does not contain this node. " + "Ignoring removeElement event."));
            }
            return;
        }
        ne.setNumberOfElements(ne.getNumberOfElements() - 1);
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(evictedEventNode.getCreationTimestamp());
    }

    protected void processAddedElement(EvictionEvent evictedEventNode) throws EvictionException {
        Fqn fqn = evictedEventNode.getFqn();
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (trace) {
                log.trace((Object)("Adding element " + fqn + " for a node that doesn't exist yet. Process as an add."));
            }
            this.processAddedNodes(evictedEventNode, 1);
            return;
        }
        ne.setNumberOfElements(ne.getNumberOfElements() + 1);
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(evictedEventNode.getCreationTimestamp());
    }

    protected void emptyRecycleQueue() throws EvictionException {
        block6: {
            Fqn fqn;
            do {
                try {
                    fqn = this.recycleQueue.poll(0L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.debug((Object)e, (Throwable)e);
                    break block6;
                }
                if (fqn == null) {
                    if (!trace) break block6;
                    log.trace((Object)"Recycle queue is empty");
                    break block6;
                }
                if (!trace) continue;
                log.trace((Object)("emptying recycle bin. Evict node " + fqn));
            } while (this.evictCacheNode(fqn));
            try {
                this.recycleQueue.put(fqn);
            }
            catch (InterruptedException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected boolean isNodeInUseAndNotTimedOut(NodeEntry ne) {
        if (ne.isCurrentlyInUse()) {
            if (ne.getInUseTimeoutTimestamp() == 0L) {
                return true;
            }
            if (System.currentTimeMillis() < ne.getInUseTimeoutTimestamp()) {
                return true;
            }
        }
        return false;
    }

    protected void prune() throws EvictionException {
        NodeEntry entry;
        while ((entry = this.evictionQueue.getFirstNodeEntry()) != null && this.shouldEvictNode(entry)) {
            this.evict(entry);
        }
    }

    public String toString() {
        return super.toString() + " recycle=" + this.recycleQueue.size() + " evict=" + this.evictionQueue.getNumberOfNodes();
    }

    protected boolean isYoungerThanMinimumTimeToLive(NodeEntry entry) {
        if (this.evictionAlgorithmConfig instanceof EvictionAlgorithmConfigBase) {
            EvictionAlgorithmConfigBase cfg = (EvictionAlgorithmConfigBase)this.evictionAlgorithmConfig;
            long minTTL = cfg.getMinTimeToLive();
            return minTTL >= 1L && entry.getModifiedTimeStamp() + minTTL > System.currentTimeMillis();
        }
        log.trace((Object)"Eviction policy implementation does not support minimum TTL!");
        return false;
    }
}

