/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class DataWriter {
    public synchronized void save(File file, byte[] d) throws Exception {
        if (file.isDirectory()) {
            return;
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream output = new FileOutputStream(file);
        this.save(output, d);
    }

    public synchronized void save(FileOutputStream output, byte[] data) throws Exception {
        FileChannel fchan = output.getChannel();
        ByteBuffer buff = ByteBuffer.allocateDirect(data.length);
        buff.put(data);
        buff.rewind();
        if (fchan.isOpen()) {
            fchan.write(buff);
        }
        buff.clear();
        fchan.close();
        output.close();
    }

    public synchronized void save(File file, InputStream input) throws Exception {
        if (file.isDirectory()) {
            return;
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream output = new FileOutputStream(file);
        this.save(output, input);
    }

    public synchronized void save(FileOutputStream output, InputStream input) throws Exception {
        ByteBuffer buff = ByteBuffer.allocateDirect(1024);
        byte[] bytes = new byte[1024];
        FileChannel fchan = output.getChannel();
        int read = 0;
        while ((read = input.read(bytes)) > -1) {
            buff.put(bytes, 0, read);
            buff.rewind();
            if (fchan.isOpen()) {
                fchan.write(buff);
            }
            buff.clear();
        }
        buff.clear();
        fchan.close();
        output.close();
    }

    public void copy(String from, String to) throws Exception {
        File src = new File(from);
        File des = new File(to);
        this.copy(src, des);
    }

    public void copy(File from, File to) throws Exception {
        FileChannel srcChannel = new FileInputStream(from).getChannel();
        FileChannel desChannel = new FileOutputStream(to).getChannel();
        srcChannel.transferTo(0L, srcChannel.size(), desChannel);
        srcChannel.close();
        desChannel.close();
    }
}

