/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.SecurityDeploymentType;
import org.jboss.system.metadata.ServiceAttributeMetaData;

public class ManagedConnectionPoolBuilder
extends AbstractBuilder {
    private static final String POOL = "org.jboss.resource.connectionmanager.JBossManagedConnectionPool";
    private static final Map<SecurityDeploymentType, String> securityTypeMap = new HashMap<SecurityDeploymentType, String>();
    private static final String MCF_JMX = "jboss.jca:service=ManagedConnectionFactory,name=";

    @Override
    public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md) {
        return ObjectNameFactory.create((String)("jboss.jca:service=ManagedConnectionPool,name=" + md.getJndiName()));
    }

    @Override
    public String getCode(ManagedConnectionFactoryDeploymentMetaData md) {
        return POOL;
    }

    @Override
    public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md) {
        ArrayList<ServiceAttributeMetaData> poolAttributes = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData poolAttribute = null;
        poolAttribute = this.buildSimpleAttribute("PoolJndiName", md.getJndiName());
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("MinSize", String.valueOf(md.getMinSize()));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("MaxSize", String.valueOf(md.getMaxSize()));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("BlockingTimeoutMillis", String.valueOf(md.getBlockingTimeoutMilliSeconds()));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("IdleTimeoutMinutes", String.valueOf(md.getIdleTimeoutMinutes()));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("BackGroundValidationMillis", String.valueOf(md.getBackgroundValidationMillis()));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("PreFill", String.valueOf(md.getPrefill()));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("StrictMin", String.valueOf(md.getUseStrictMin()));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildSimpleAttribute("StatisticsFormatter", md.getStatisticsFormatter());
        poolAttributes.add(poolAttribute);
        poolAttribute = md.getSecurityMetaData() == null ? this.buildSimpleAttribute("Criteria", "ByNothing") : this.buildSimpleAttribute("Criteria", String.valueOf(this.getCriteria(md.getSecurityMetaData().getSecurityDeploymentType())));
        poolAttributes.add(poolAttribute);
        poolAttribute = this.buildDependencyAttribute("ManagedConnectionFactoryName", MCF_JMX + md.getJndiName());
        poolAttributes.add(poolAttribute);
        return poolAttributes;
    }

    private String getCriteria(SecurityDeploymentType type) {
        return securityTypeMap.get(type);
    }

    static {
        securityTypeMap.put(SecurityDeploymentType.NONE, "ByNothing");
        securityTypeMap.put(SecurityDeploymentType.APPLICATION, "ByApplication");
        securityTypeMap.put(SecurityDeploymentType.DOMAIN, "ByContainer");
        securityTypeMap.put(SecurityDeploymentType.DOMAIN_AND_APPLICATION, "ByContainerAndApplication");
    }
}

