/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.ComponentAdapter;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentVisitor<C, T>
extends ComponentAdapter<C>
implements DeploymentVisitor<T> {
    private Logger log = Logger.getLogger(this.getClass());

    @Override
    protected String getAttachmentName(C attachment) {
        return this.getComponentType().getName();
    }

    protected abstract List<? extends C> getComponents(T var1);

    protected abstract Class<C> getComponentType();

    @Override
    public void deploy(DeploymentUnit unit, T deployment) throws DeploymentException {
        List<C> components = this.getComponents(deployment);
        if (components != null && !components.isEmpty()) {
            ArrayList<C> visited = new ArrayList<C>();
            try {
                for (C component : components) {
                    this.addComponent(unit, component);
                    visited.add(component);
                }
            }
            catch (Throwable t) {
                for (int i = visited.size() - 1; i >= 0; --i) {
                    this.safeRemoveComponent(unit, visited.get(i));
                }
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + unit.getName()), (Throwable)t);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit, T deployment) {
        List<C> components = this.getComponents(deployment);
        if (components != null && !components.isEmpty()) {
            for (C component : components) {
                this.safeRemoveComponent(unit, component);
            }
        }
    }

    protected void safeRemoveComponent(DeploymentUnit unit, C attachment) {
        try {
            this.removeComponent(unit, attachment);
        }
        catch (Throwable ignored) {
            this.log.warn((Object)("Error during component removal: " + unit.getName()), ignored);
        }
    }
}

