/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport;

import java.net.URI;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.wsrm.RMClientSequence;
import org.jboss.ws.extensions.wsrm.transport.RMMessage;
import org.jboss.ws.extensions.wsrm.transport.RMMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RMTransportHelper {
    private static Logger logger = Logger.getLogger(RMTransportHelper.class);

    private RMTransportHelper() {
    }

    public static boolean isRMMessage(Map<String, Object> ctx) {
        return ctx != null && ctx.containsKey("wsrm.requestContext");
    }

    public static String getAddressingMessageId(RMMessage rmRequest) {
        return (String)RMTransportHelper.getWsrmRequestContext(rmRequest).get("wsrm.wsaMessageId");
    }

    public static URI getBackPortURI(RMMessage rmRequest) {
        return RMTransportHelper.getSequence(rmRequest).getBackPort();
    }

    private static Map<String, Object> getWsrmRequestContext(RMMessage rmRequest) {
        Map<String, Object> invocationCtx = rmRequest.getMetadata().getContext("invocationContext");
        return (Map)invocationCtx.get("wsrm.requestContext");
    }

    public static RMClientSequence getSequence(RMMessage rmRequest) {
        return (RMClientSequence)RMTransportHelper.getWsrmRequestContext(rmRequest).get("wsrm.sequenceReference");
    }

    public static boolean isOneWayOperation(RMMessage rmRequest) {
        RMMetadata meta = rmRequest.getMetadata();
        if (meta == null) {
            throw new RuntimeException("Unable to obtain wsrm metadata");
        }
        Map<String, Object> invCtx = meta.getContext("invocationContext");
        if (invCtx == null) {
            throw new RuntimeException("Unable to obtain invocation context");
        }
        Map wsrmReqCtx = (Map)invCtx.get("wsrm.requestContext");
        Boolean isOneWay = (Boolean)wsrmReqCtx.get("wsrm.oneWayOperation");
        return isOneWay == null ? false : isOneWay;
    }
}

