/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.spi.VFSContextFactory;

public abstract class AbstractContextFactory
implements VFSContextFactory {
    private String[] protocols;

    protected AbstractContextFactory(String ... protocols) {
        this.protocols = protocols;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    protected static URL fromVFS(URL url) throws MalformedURLException {
        String externalForm = url.toExternalForm();
        if (externalForm.startsWith("vfs")) {
            return new URL(externalForm.substring(3));
        }
        return url;
    }

    protected static URI fromVFS(URI uri) throws URISyntaxException {
        String scheme = uri.getScheme();
        if (scheme.startsWith("vfs")) {
            return new URI(scheme.substring(3), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri;
    }
}

