/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.annotation.factory.AnnotationProxy;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;

public class DsDataSourceTemplateInfo
extends BasicDeploymentTemplateInfo {
    private static final long serialVersionUID = 1L;
    private static final Map<String, MetaValue> defaultValues = new HashMap<String, MetaValue>();
    private Map<String, String> propertyNameMappings;
    private String dsType = "local-tx-datasource";

    public DsDataSourceTemplateInfo(String arg0, String arg1, Map<String, ManagedProperty> arg2) {
        super(arg0, arg1, arg2);
    }

    public DsDataSourceTemplateInfo(String name, String description, String datasourceType) {
        super(name, description);
        this.dsType = datasourceType;
    }

    public Map<String, String> getPropertyNameMappings() {
        return this.propertyNameMappings;
    }

    public void setPropertyNameMappings(Map<String, String> propertyNameMappings) {
        this.propertyNameMappings = propertyNameMappings;
    }

    public String getConnectionFactoryType() {
        return this.dsType;
    }

    public void setConnectionFactoryType(String dsType) {
        this.dsType = dsType;
    }

    public void start() {
        this.populate();
    }

    public DsDataSourceTemplateInfo copy() {
        DsDataSourceTemplateInfo copy = new DsDataSourceTemplateInfo(this.getName(), this.getDescription(), this.getProperties());
        copy.setPropertyNameMappings(this.propertyNameMappings);
        copy.setConnectionFactoryType(this.getConnectionFactoryType());
        super.copy((BasicDeploymentTemplateInfo)copy);
        copy.populate();
        return copy;
    }

    private void populate() {
        this.populateDefaultValues();
        DefaultFieldsImpl fields = new DefaultFieldsImpl("dsType");
        fields.setDescription("The datasource type");
        fields.setMetaType((MetaType)SimpleMetaType.STRING);
        fields.setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)this.dsType)));
        fields.setField("readOnly", (Object)Boolean.TRUE);
        ManagedPropertyImpl dsTypeMP = new ManagedPropertyImpl((Fields)fields);
        this.addProperty((ManagedProperty)dsTypeMP);
    }

    private void populateDefaultValues() {
        if (this.getProperties() == null) {
            return;
        }
        for (ManagedProperty property : this.getProperties().values()) {
            String mappedName;
            String name = property.getName();
            Fields f = property.getFields();
            if (this.propertyNameMappings != null && (mappedName = this.propertyNameMappings.get(name)) != null) {
                f.setField("mappedName", (Object)mappedName);
            }
            ManagedPropertyImpl newProperty = new ManagedPropertyImpl(f);
            MetaValue v = defaultValues.get(name);
            if (v != null) {
                newProperty.setValue(v);
            }
            this.addProperty((ManagedProperty)newProperty);
        }
    }

    private void addID(ManagedPropertyImpl mp) {
        HashMap<String, ManagementObjectID> annotations = new HashMap<String, ManagementObjectID>();
        Map idFields = Collections.emptyMap();
        try {
            ManagementObjectID id = (ManagementObjectID)AnnotationProxy.createProxy(idFields, ManagementObjectID.class);
            annotations.put(ManagementObjectID.class.getName(), id);
            mp.setAnnotations(annotations);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    static {
        defaultValues.put("use-java-context", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(true)));
        defaultValues.put("min-pool-size", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(0)));
        defaultValues.put("max-pool-size", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(10)));
        defaultValues.put("blocking-timeout-millis", (MetaValue)new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Integer.valueOf(3000)));
        defaultValues.put("idle-timeout-minutes", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(30)));
        defaultValues.put("background-validation", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(false)));
        defaultValues.put("background-validation-millis", (MetaValue)new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Integer.valueOf(0)));
        defaultValues.put("validate-on-match", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(true)));
        defaultValues.put("interleaving", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(false)));
        defaultValues.put("allocation-retry", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(0)));
        defaultValues.put("allocation-retry-wait-millis", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(5000)));
        defaultValues.put("prepared-statement-cache-size", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(0)));
        defaultValues.put("share-prepared-statements", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(false)));
        defaultValues.put("set-tx-query-timeout", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(false)));
        defaultValues.put("query-timeout", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(0)));
    }
}

