/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AbstractClassPoolDomain;
import org.jboss.aop.classpool.BaseClassPool;
import org.jboss.aop.classpool.ClassPoolDomain;
import org.jboss.aop.util.ClassLoaderUtils;

public class DelegatingClassPool
extends BaseClassPool {
    private final AbstractClassPoolDomain domain;
    private boolean closed;

    public DelegatingClassPool(ClassPoolDomain domain, ClassLoader cl, ClassPool parent, ScopedClassPoolRepository repository) {
        super(cl, parent, repository);
        if (domain == null) {
            throw new IllegalArgumentException("Domain was null");
        }
        if (!(domain instanceof AbstractClassPoolDomain)) {
            throw new IllegalArgumentException("Domain must implement AbstractClassPoolDomain");
        }
        this.domain = (AbstractClassPoolDomain)domain;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " domain:" + (Object)((Object)this)));
        }
        this.domain.addClassPool(this);
    }

    public CtClass loadLocally(String classname, String resourceName, boolean create) {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " attempt to load locally " + classname));
        }
        CtClass clazz = null;
        if (this.isLocalResource(resourceName, trace) && (clazz = this.getCachedLocally(classname)) == null && create) {
            clazz = this.createCtClass(classname, true);
        }
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " loaded locally " + classname + " " + this.getClassPoolLogStringForClass(clazz)));
        }
        return clazz;
    }

    public synchronized CtClass get0(String classname, boolean useCache) throws NotFoundException {
        if (this.isGeneratedClass(classname)) {
            return null;
        }
        CtClass clazz = this.domain.getCachedOrCreate(this, classname, true);
        if (clazz == null) {
            clazz = this.loadLocally(classname, ClassLoaderUtils.getResourceName((String)classname), true);
        }
        return clazz;
    }

    public boolean isUnloadedClassLoader() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        super.close();
        this.domain.removeClassPool(this);
    }

    public CtClass getCached(String classname) {
        if (this.isGeneratedClass(classname)) {
            return null;
        }
        return this.domain.getCachedOrCreate(this, classname, false);
    }

    public String toString() {
        return "[" + super.toString() + " domain: " + this.domain + "]";
    }
}

