/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.group.composite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoGroupComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Double availability;
    private ResourceType resourceType;
    private ResourceSubCategory subcategory;
    private long memberCount;
    private int depth;
    private boolean mainResource;
    private Resource parentResource;
    private List<Resource> resources;

    public AutoGroupComposite(AutoGroupComposite other) {
        if (other == null) {
            return;
        }
        this.availability = other.availability;
        this.resourceType = other.resourceType;
        this.subcategory = other.subcategory;
        this.memberCount = other.memberCount;
        this.depth = other.depth;
        this.mainResource = other.mainResource;
        this.parentResource = other.parentResource;
        this.resources = new ArrayList<Resource>();
        if (other.resources != null) {
            this.resources.addAll(other.resources);
        }
    }

    public AutoGroupComposite(Double availability, Resource parentResource, ResourceType resourceType, long memberCount) {
        this.availability = availability;
        this.parentResource = parentResource;
        this.resourceType = resourceType;
        this.memberCount = memberCount;
    }

    public AutoGroupComposite(Double availability, Resource parentResource, ResourceSubCategory subcategory, long memberCount) {
        this.availability = availability;
        this.parentResource = parentResource;
        this.subcategory = subcategory;
        this.memberCount = memberCount;
    }

    public Double getAvailability() {
        return this.availability;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public long getMemberCount() {
        return this.memberCount;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public ResourceSubCategory getSubcategory() {
        return this.subcategory;
    }

    public Resource getParentResource() {
        return this.parentResource;
    }

    public void setParentResource(Resource parentResource) {
        this.parentResource = parentResource;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int increaseDepth(int increment) {
        this.depth += increment;
        return this.depth;
    }

    public boolean isMainResource() {
        return this.mainResource;
    }

    public void setMainResource(boolean mainResource) {
        this.mainResource = mainResource;
    }

    public String toString() {
        return "AutoGroupComposite[" + (this.resourceType != null ? "Resource: " : "Subcategory: ") + "name=" + (this.resourceType != null ? this.resourceType.getName() : this.subcategory.getName()) + ", members=" + this.memberCount + ", availability=" + this.availability + "]";
    }
}

