/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import org.rhq.core.clientapi.util.ArrayUtil;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitsConstants;

class UnitsUtil {
    static final BigDecimal FACT_NONE = new BigDecimal(1);
    static final BigDecimal FACT_KILO_BIN = new BigDecimal(1024);
    static final BigDecimal FACT_MEGA_BIN = FACT_KILO_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_GIGA_BIN = FACT_MEGA_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_TERA_BIN = FACT_GIGA_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_PETA_BIN = FACT_TERA_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_NANOS = new BigDecimal(1);
    static final BigDecimal FACT_MICROS = new BigDecimal(1000);
    static final BigDecimal FACT_MILLIS = new BigDecimal(1000000);
    static final BigDecimal FACT_JIFFYS = new BigDecimal(10000000);
    static final BigDecimal FACT_SECS = FACT_MILLIS.multiply(new BigDecimal(1000));
    static final BigDecimal FACT_MINS = FACT_SECS.multiply(new BigDecimal(60));
    static final BigDecimal FACT_HOURS = FACT_MINS.multiply(new BigDecimal(60));
    static final BigDecimal FACT_DAYS = FACT_HOURS.multiply(new BigDecimal(24));
    static final BigDecimal FACT_WEEKS = FACT_DAYS.multiply(new BigDecimal(7));
    static final BigDecimal FACT_YEARS = FACT_DAYS.multiply(new BigDecimal(365));

    UnitsUtil() {
    }

    static void checkValidScaleForUnits(UnitsConstants unit, ScaleConstants scale) {
        EnumSet<ScaleConstants> weightSet = ScaleConstants.getBinaryScaleSet();
        EnumSet<ScaleConstants> timeSet = ScaleConstants.getTimeSet();
        if (!(scale == ScaleConstants.SCALE_NONE || (unit == UnitsConstants.UNIT_BYTES || unit == UnitsConstants.UNIT_BITS) && weightSet.contains((Object)scale) || (unit == UnitsConstants.UNIT_DURATION || unit == UnitsConstants.UNIT_DATE) && timeSet.contains((Object)scale) || unit == UnitsConstants.UNIT_PERCENTAGE && scale != ScaleConstants.SCALE_NONE || unit == UnitsConstants.UNIT_NONE && scale != ScaleConstants.SCALE_NONE)) {
            throw new IllegalArgumentException("Scale is not valid for the specified units");
        }
    }

    static int findNonNumberIdx(String val, NumberFormat fmt) {
        ParsePosition pos = new ParsePosition(0);
        fmt.parse(val, pos);
        if (pos.getIndex() == val.length()) {
            return -1;
        }
        return pos.getIndex();
    }

    public static NumberFormat getNumberFormat(double[] inValues, Locale locale) {
        NumberFormat res = NumberFormat.getInstance(locale);
        double[] values = new double[inValues.length];
        System.arraycopy(inValues, 0, values, 0, inValues.length);
        Arrays.sort(values);
        values = ArrayUtil.uniq(values);
        if (values.length < 2) {
            res.setMinimumFractionDigits(1);
            res.setMaximumFractionDigits(1);
            return res;
        }
        Object[] sValues = new String[values.length];
        for (int numDigits = 0; numDigits < 9; ++numDigits) {
            res.setMinimumFractionDigits(numDigits);
            res.setMaximumFractionDigits(numDigits);
            for (int i = 0; i < sValues.length; ++i) {
                sValues[i] = res.format(values[i]);
            }
            Arrays.sort(sValues);
            if (ArrayUtil.isUniq((String[])sValues)) break;
        }
        return res;
    }

    public static int getUniqueDigits(double[] inValues, Locale locale) {
        return UnitsUtil.getNumberFormat(inValues, locale).getMaximumFractionDigits();
    }
}

