/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class PPTDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"application/powerpoint", "application/ppt"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        try {
            PowerPointExtractor ppe;
            try {
                ppe = new PowerPointExtractor(is);
            }
            catch (IOException e) {
                String string = "";
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return string;
            }
            String string = ppe.getText(true, true);
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties(is);
        return reader.getProperties();
    }
}

