/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.service;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.service.JMXConnectorServerServiceMBean;
import org.jboss.net.sockets.DefaultSocketFactory;

public class JMXConnectorServerService
implements JMXConnectorServerServiceMBean {
    public static final String JNDI_PATH_DEFAULT = "/jmxconnector";
    private MBeanServer mbeanServer;
    private InetAddress bindAddress;
    private int registryPort = 1099;
    private String jndiPath = "/jmxconnector";
    private JMXConnectorServer connectorServer = null;
    private Registry rmiRegistry = null;
    private static final Logger log = Logger.getLogger(JMXConnectorServerService.class);

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public void setBindAddress(String bindAddress) throws UnknownHostException {
        this.bindAddress = this.toInetAddress(bindAddress);
    }

    public String getBindAddress() {
        if (this.bindAddress != null) {
            return this.bindAddress.getHostAddress();
        }
        return null;
    }

    public String getJndiPath() {
        return this.jndiPath;
    }

    public void setJndiPath(String jndiPath) {
        this.jndiPath = jndiPath;
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        String host = System.getProperty("java.rmi.server.hostname");
        this.rmiRegistry = LocateRegistry.getRegistry(host, this.registryPort);
        if (this.rmiRegistry != null) {
            try {
                this.rmiRegistry.list();
            }
            catch (RemoteException e) {
                log.debug((Object)("No registry running at host '" + host + "', port '" + this.registryPort + "'.  Will create one."));
                this.rmiRegistry = LocateRegistry.createRegistry(this.registryPort, null, (RMIServerSocketFactory)new DefaultSocketFactory(this.bindAddress));
            }
        } else {
            this.rmiRegistry = LocateRegistry.createRegistry(this.registryPort, null, (RMIServerSocketFactory)new DefaultSocketFactory(this.bindAddress));
        }
        String serviceURL = "service:jmx:rmi://" + host + "/jndi/rmi://" + host + ":" + this.registryPort + this.jndiPath;
        JMXServiceURL url = new JMXServiceURL(serviceURL);
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbeanServer);
        this.connectorServer.start();
        log.info((Object)("JMX Connector server: " + serviceURL));
    }

    public void stop() throws IOException {
        if (this.connectorServer != null) {
            this.connectorServer.stop();
        }
    }

    public void destroy() {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mbeanServer = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean aBoolean) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    private InetAddress toInetAddress(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return null;
        }
        return InetAddress.getByName(host);
    }
}

