/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management;

import java.util.Date;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.framework.management.ManagedEndpointMBean;
import org.jboss.wsf.framework.management.recording.ManagedRecordProcessor;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.recording.Record;
import org.jboss.wsf.spi.management.recording.RecordProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedEndpoint
implements ManagedEndpointMBean {
    private Endpoint endpoint;
    private MBeanServer mbeanServer;
    private Logger log = Logger.getLogger(this.getClass());

    public ManagedEndpoint(Endpoint endpoint, MBeanServer mbeanServer) {
        this.endpoint = endpoint;
        this.mbeanServer = mbeanServer;
    }

    @Override
    public long getAverageProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getAverageProcessingTime() : 0L;
    }

    @Override
    public long getFaultCount() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getFaultCount() : 0L;
    }

    @Override
    public long getMaxProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getMaxProcessingTime() : 0L;
    }

    @Override
    public long getMinProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getMinProcessingTime() : 0L;
    }

    @Override
    public long getRequestCount() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getRequestCount() : 0L;
    }

    @Override
    public long getResponseCount() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getResponseCount() : 0L;
    }

    @Override
    public Date getStartTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getStartTime() : null;
    }

    @Override
    public Date getStopTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getStopTime() : null;
    }

    @Override
    public long getTotalProcessingTime() {
        EndpointMetrics metrics = this.endpoint.getEndpointMetrics();
        return metrics != null ? metrics.getTotalProcessingTime() : 0L;
    }

    @Override
    public void start() {
        this.endpoint.getLifecycleHandler().start(this.endpoint);
    }

    @Override
    public void stop() {
        this.endpoint.getLifecycleHandler().stop(this.endpoint);
    }

    @Override
    public void processRecord(Record record) {
        this.endpoint.processRecord(record);
    }

    @Override
    public void addRecordProcessor(RecordProcessor processor) {
        this.getRecordProcessors().add(processor);
        try {
            this.mbeanServer.registerMBean(processor, ObjectNameFactory.create((String)(this.endpoint.getName() + ",recordProcessor=" + processor.getName())));
        }
        catch (JMException ex) {
            this.log.debug((Object)("Cannot register endpoint with JMX server, trying with the default ManagedRecordProcessor: " + ex.getMessage()));
            try {
                this.mbeanServer.registerMBean(new ManagedRecordProcessor(processor), ObjectNameFactory.create((String)(this.endpoint.getName() + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException innerEx) {
                this.log.error((Object)"Cannot register endpoint with JMX server", (Throwable)innerEx);
            }
        }
    }

    @Override
    public List<RecordProcessor> getRecordProcessors() {
        return this.endpoint.getRecordProcessors();
    }

    @Override
    public void setRecordProcessors(List<RecordProcessor> processors) {
        for (RecordProcessor processor : processors) {
            try {
                this.mbeanServer.unregisterMBean(ObjectNameFactory.create((String)(this.endpoint.getName() + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException ex) {
                this.log.error((Object)"Cannot unregister record processor with JMX server", (Throwable)ex);
            }
        }
        this.endpoint.setRecordProcessors(processors);
        for (RecordProcessor processor : processors) {
            try {
                this.mbeanServer.registerMBean(processor, ObjectNameFactory.create((String)(this.endpoint.getName() + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException ex) {
                this.log.debug((Object)("Cannot register endpoint with JMX server, trying with the default ManagedRecordProcessor: " + ex.getMessage()));
                try {
                    this.mbeanServer.registerMBean(new ManagedRecordProcessor(processor), ObjectNameFactory.create((String)(this.endpoint.getName() + ",recordProcessor=" + processor.getName())));
                }
                catch (JMException innerEx) {
                    this.log.error((Object)"Cannot register endpoint with JMX server", (Throwable)innerEx);
                }
            }
        }
    }
}

