/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory.javassist;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.annotation.factory.javassist.AnnotationProxy;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.TypeInfoFactory;

public class MemberValueGetter
implements MemberValueVisitor {
    Object value;
    Method method;
    static TypeInfoFactory typeFactory = new IntrospectionTypeInfoFactory();

    public MemberValueGetter(Method method) {
        this.method = method;
    }

    public Object getValue() {
        return this.value;
    }

    public void visitAnnotationMemberValue(AnnotationMemberValue node) {
        try {
            Annotation ann = node.getValue();
            this.value = AnnotationProxy.createProxy(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visitArrayMemberValue(ArrayMemberValue node) {
        MemberValue[] values = node.getValue();
        this.value = node.getValue();
        Object vals = Array.newInstance(this.getAttributeType(), values.length);
        for (int i = 0; i < values.length; ++i) {
            values[i].accept((MemberValueVisitor)this);
            Array.set(vals, i, this.value);
        }
        this.value = vals;
    }

    public void visitBooleanMemberValue(BooleanMemberValue node) {
        this.value = new Boolean(node.getValue());
    }

    public void visitByteMemberValue(ByteMemberValue node) {
        this.value = new Byte(node.getValue());
    }

    public void visitCharMemberValue(CharMemberValue node) {
        this.value = new Character(node.getValue());
    }

    public void visitDoubleMemberValue(DoubleMemberValue node) {
        this.value = new Double(node.getValue());
    }

    public void visitEnumMemberValue(EnumMemberValue node) {
        this.value = Enum.valueOf(this.getAttributeType(), node.getValue());
    }

    public void visitFloatMemberValue(FloatMemberValue node) {
        this.value = new Float(node.getValue());
    }

    public void visitIntegerMemberValue(IntegerMemberValue node) {
        this.value = new Integer(node.getValue());
    }

    public void visitLongMemberValue(LongMemberValue node) {
        this.value = new Long(node.getValue());
    }

    public void visitShortMemberValue(ShortMemberValue node) {
        this.value = new Short(node.getValue());
    }

    public void visitStringMemberValue(StringMemberValue node) {
        this.value = node.getValue();
    }

    public void visitClassMemberValue(ClassMemberValue node) {
        try {
            this.value = Class.forName(node.getValue());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Class getAttributeType() {
        Class<?> rtn = this.method.getReturnType();
        while (rtn.isArray()) {
            rtn = rtn.getComponentType();
        }
        return rtn;
    }
}

