/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.agent.metadata.ContentMetadataParser;
import org.rhq.core.clientapi.agent.metadata.EventsMetadataParser;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.agent.metadata.MetricsMetadataParser;
import org.rhq.core.clientapi.agent.metadata.OperationsMetadataParser;
import org.rhq.core.clientapi.agent.metadata.SubCategoriesMetadataParser;
import org.rhq.core.clientapi.descriptor.plugin.ContentDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.EventDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.MetricDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.OperationDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ParentResourceType;
import org.rhq.core.clientapi.descriptor.plugin.PlatformDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ProcessScanDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ResourceCreateDeletePolicy;
import org.rhq.core.clientapi.descriptor.plugin.ResourceCreationData;
import org.rhq.core.clientapi.descriptor.plugin.ResourceDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.RunsInsideType;
import org.rhq.core.clientapi.descriptor.plugin.ServerDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ServiceDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.SubCategoryDescriptor;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.CreateDeletePolicy;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginMetadataParser {
    private static final Log LOG = LogFactory.getLog(PluginMetadataParser.class);
    private PluginDescriptor pluginDescriptor;
    private List<ResourceType> resourceTypes = new ArrayList<ResourceType>();
    private LinkedHashSet<ResourceType> rootResourceTypes = new LinkedHashSet();
    private Map<ResourceType, String> discoveryClasses = new HashMap<ResourceType, String>();
    private Map<ResourceType, String> componentClasses = new HashMap<ResourceType, String>();
    private final Map<String, PluginMetadataParser> parsersByPlugin;

    public PluginMetadataParser(PluginDescriptor descriptor, Map<String, PluginMetadataParser> parsersByPlugin) throws InvalidPluginDescriptorException {
        this.pluginDescriptor = descriptor;
        this.parsersByPlugin = parsersByPlugin;
        this.parseDescriptor();
    }

    public String getPluginLifecycleListenerClass() {
        String pkg = this.pluginDescriptor.getPackage();
        String clazz = this.pluginDescriptor.getPluginLifecycleListener();
        return this.getFullyQualifiedComponentClassName(pkg, clazz);
    }

    public List<ResourceType> getAllTypes() {
        return new ArrayList<ResourceType>(this.resourceTypes);
    }

    public Set<ResourceType> getRootResourceTypes() {
        return this.rootResourceTypes;
    }

    public void parseDescriptor() throws InvalidPluginDescriptorException {
        for (PlatformDescriptor platformDescriptor : this.pluginDescriptor.getPlatforms()) {
            this.rootResourceTypes.add(this.parsePlatformDescriptor(platformDescriptor));
        }
        for (ServerDescriptor serverDescriptor : this.pluginDescriptor.getServers()) {
            this.rootResourceTypes.add(this.parseServerDescriptor(serverDescriptor, null));
        }
        for (ServiceDescriptor serviceDescriptor : this.pluginDescriptor.getServices()) {
            this.rootResourceTypes.add(this.parseServiceDescriptor(serviceDescriptor, null, null));
        }
    }

    private ResourceType parsePlatformDescriptor(PlatformDescriptor platformDescriptor) throws InvalidPluginDescriptorException {
        ResourceType platformResourceType = new ResourceType(platformDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.PLATFORM, null);
        platformResourceType.setDescription(platformDescriptor.getDescription());
        LOG.debug((Object)("Parsed platform resource type: " + platformResourceType));
        this.parseResourceDescriptor(platformDescriptor, platformResourceType, null, null, null);
        if (platformResourceType.getProcessScans() != null && platformResourceType.getProcessScans().size() > 0) {
            LOG.warn((Object)("Platforms are not auto-discovered via process scans. The <process-scan> elements will be ignored in resource type: " + platformResourceType));
        }
        return platformResourceType;
    }

    private ResourceType parseServerDescriptor(ServerDescriptor serverDescriptor, ResourceType parentServerType) throws InvalidPluginDescriptorException {
        ResourceType serverResourceType;
        String sourcePlugin = serverDescriptor.getSourcePlugin();
        String sourceServer = serverDescriptor.getSourceType();
        sourcePlugin = sourcePlugin == null ? "" : sourcePlugin.trim();
        String string = sourceServer = sourceServer == null ? "" : sourceServer.trim();
        if (sourcePlugin.length() == 0 && sourceServer.length() == 0) {
            serverResourceType = new ResourceType(serverDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVER, parentServerType);
            serverResourceType.setDescription(serverDescriptor.getDescription());
            serverResourceType.setCreationDataType(this.convertCreationDataType(serverDescriptor.getCreationDataType()));
            serverResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serverDescriptor.getCreateDeletePolicy()));
            serverResourceType.setSingleton(serverDescriptor.isSingleton());
            this.parseResourceDescriptor(serverDescriptor, serverResourceType, null, null, null);
            LOG.debug((Object)("Parsed server Resource type: " + serverResourceType));
        } else if (sourcePlugin.length() > 0 && sourceServer.length() > 0) {
            Map<String, ServerDescriptor> pluginServerDescriptors = this.getPluginServerDescriptors(sourcePlugin);
            ServerDescriptor sourceServerDescriptor = pluginServerDescriptors.get(sourceServer);
            if (sourceServerDescriptor == null) {
                throw new InvalidPluginDescriptorException("There is no server type named [" + sourceServer + "] from a plugin named [" + sourcePlugin + "]; please check the descriptor of type [" + serverDescriptor.getName() + "]");
            }
            serverResourceType = new ResourceType(serverDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVER, parentServerType);
            serverResourceType.setDescription(serverDescriptor.getDescription());
            PluginMetadataParser.setSubCategory(serverDescriptor, serverResourceType);
            serverResourceType.setCreationDataType(this.convertCreationDataType(serverDescriptor.getCreationDataType()));
            serverResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serverDescriptor.getCreateDeletePolicy()));
            serverResourceType.setSingleton(serverDescriptor.isSingleton());
            String discoveryClass = serverDescriptor.getDiscovery() != null ? this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), serverDescriptor.getDiscovery()) : this.getFullyQualifiedComponentClassName(this.getPluginPackage(sourcePlugin), sourceServerDescriptor.getDiscovery());
            String componentClass = serverDescriptor.getClazz() != null ? this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), serverDescriptor.getClazz()) : this.getFullyQualifiedComponentClassName(this.getPluginPackage(sourcePlugin), sourceServerDescriptor.getClazz());
            this.parseResourceDescriptor(sourceServerDescriptor, serverResourceType, discoveryClass, componentClass, sourcePlugin);
            for (ServerDescriptor childServerDescriptor : serverDescriptor.getServers()) {
                this.parseServerDescriptor(childServerDescriptor, serverResourceType);
            }
            for (ServiceDescriptor childServiceDescriptor : serverDescriptor.getServices()) {
                this.parseServiceDescriptor(childServiceDescriptor, serverResourceType, null);
            }
        } else {
            throw new InvalidPluginDescriptorException("Both sourcePlugin and sourceType must be defined: " + serverDescriptor.getName());
        }
        serverResourceType.setSupportsManualAdd(serverDescriptor.isSupportsManualAdd());
        RunsInsideType runsInside = serverDescriptor.getRunsInside();
        if (runsInside != null) {
            List<ParentResourceType> parentTypesDescriptor = runsInside.getParentResourceType();
            for (ParentResourceType parentTypeDescriptor : parentTypesDescriptor) {
                String parentTypePlugin;
                String parentTypeName = parentTypeDescriptor.getName();
                ResourceType parentTypeToInjectInto = this.getResourceTypeFromPlugin(parentTypeName, parentTypePlugin = parentTypeDescriptor.getPlugin());
                if (parentTypeToInjectInto == null) {
                    throw new InvalidPluginDescriptorException("There is no resource type named [" + parentTypeName + "] from a plugin named [" + parentTypePlugin + "]; please check the descriptor of type [" + serverDescriptor.getName() + "]");
                }
                parentTypeToInjectInto.addChildResourceType(serverResourceType);
            }
        }
        return serverResourceType;
    }

    private ResourceType parseServiceDescriptor(ServiceDescriptor serviceDescriptor, ResourceType parentType, String parentSource) throws InvalidPluginDescriptorException {
        RunsInsideType runsInside;
        ResourceType serviceResourceType;
        String sourcePlugin = serviceDescriptor.getSourcePlugin();
        String sourceService = serviceDescriptor.getSourceType();
        if (sourcePlugin == null) {
            sourcePlugin = parentSource;
        }
        sourcePlugin = sourcePlugin == null ? "" : sourcePlugin.trim();
        String string = sourceService = sourceService == null ? "" : sourceService.trim();
        if (sourcePlugin.length() == 0 && sourceService.length() == 0) {
            serviceResourceType = new ResourceType(serviceDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVICE, parentType);
            serviceResourceType.setDescription(serviceDescriptor.getDescription());
            serviceResourceType.setCreationDataType(this.convertCreationDataType(serviceDescriptor.getCreationDataType()));
            serviceResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serviceDescriptor.getCreateDeletePolicy()));
            serviceResourceType.setSingleton(serviceDescriptor.isSingleton());
            this.parseResourceDescriptor(serviceDescriptor, serviceResourceType, null, null, null);
            LOG.debug((Object)("Parsed service Resource type: " + serviceResourceType));
            if (serviceResourceType.getProcessScans() != null && serviceResourceType.getProcessScans().size() > 0) {
                LOG.warn((Object)("Child services are not auto-discovered via process scans. The <process-scan> elements will be ignored in resource type: " + serviceResourceType));
            }
        } else if (sourcePlugin.length() > 0) {
            ServiceDescriptor sourceServiceDescriptor;
            if (sourceService.length() == 0) {
                sourceServiceDescriptor = serviceDescriptor;
            } else {
                Map<String, ServiceDescriptor> pluginServiceDescriptors = this.getPluginServiceDescriptors(sourcePlugin);
                sourceServiceDescriptor = pluginServiceDescriptors.get(sourceService);
            }
            if (sourceServiceDescriptor == null) {
                throw new InvalidPluginDescriptorException("There is no service type named [" + sourceService + "] from a plugin named [" + sourcePlugin + "]; please check the descriptor of type [" + serviceDescriptor.getName() + "]");
            }
            serviceResourceType = new ResourceType(serviceDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVICE, parentType);
            serviceResourceType.setDescription(serviceDescriptor.getDescription());
            PluginMetadataParser.setSubCategory(serviceDescriptor, serviceResourceType);
            serviceResourceType.setCreationDataType(this.convertCreationDataType(serviceDescriptor.getCreationDataType()));
            serviceResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serviceDescriptor.getCreateDeletePolicy()));
            serviceResourceType.setSingleton(serviceDescriptor.isSingleton());
            String discoveryClass = serviceDescriptor.getDiscovery() != null ? this.getFullyQualifiedComponentClassName(this.getPluginPackage(sourcePlugin), serviceDescriptor.getDiscovery()) : this.getFullyQualifiedComponentClassName(this.getPluginPackage(sourcePlugin), sourceServiceDescriptor.getDiscovery());
            String componentClass = serviceDescriptor.getClazz() != null ? this.getFullyQualifiedComponentClassName(this.getPluginPackage(sourcePlugin), serviceDescriptor.getClazz()) : this.getFullyQualifiedComponentClassName(this.getPluginPackage(sourcePlugin), sourceServiceDescriptor.getClazz());
            this.parseResourceDescriptor(sourceServiceDescriptor, serviceResourceType, discoveryClass, componentClass, sourcePlugin);
        } else {
            throw new InvalidPluginDescriptorException("Both sourcePlugin and sourceType must be defined: " + serviceDescriptor.getName());
        }
        serviceResourceType.setSupportsManualAdd(serviceDescriptor.isSupportsManualAdd());
        if (parentType == null && (runsInside = serviceDescriptor.getRunsInside()) != null) {
            List<ParentResourceType> parentTypesDescriptor = runsInside.getParentResourceType();
            for (ParentResourceType parentTypeDescriptor : parentTypesDescriptor) {
                String parentTypePlugin;
                String parentTypeName = parentTypeDescriptor.getName();
                ResourceType parentTypeToInjectInto = this.getResourceTypeFromPlugin(parentTypeName, parentTypePlugin = parentTypeDescriptor.getPlugin());
                if (parentTypeToInjectInto == null) {
                    throw new InvalidPluginDescriptorException("There is no resource type named [" + parentTypeName + "] from a plugin named [" + parentTypePlugin + "]; please check the descriptor of type [" + serviceDescriptor.getName() + "]");
                }
                parentTypeToInjectInto.addChildResourceType(serviceResourceType);
            }
        }
        return serviceResourceType;
    }

    private static void setSubCategory(ResourceDescriptor resourceDescriptor, ResourceType resourceType) throws InvalidPluginDescriptorException {
        String subCatName = resourceDescriptor.getSubCategory();
        if (subCatName != null) {
            ResourceSubCategory subCat = SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor(resourceType, subCatName);
            if (subCat == null) {
                throw new InvalidPluginDescriptorException("Resource type [" + resourceType.getName() + "] specified a subcategory (" + subCatName + ") that is not defined as a child subcategory of one of its ancestor resource types.");
            }
            resourceType.setSubCategory(subCat);
        }
    }

    private void parseResourceDescriptor(ResourceDescriptor resourceDescriptor, ResourceType resourceType, String discoveryClass, String componentClass, String sourcePlugin) throws InvalidPluginDescriptorException {
        if (resourceType.getDescription() == null) {
            resourceType.setDescription(resourceDescriptor.getDescription());
        }
        if (resourceType.getSubCategory() == null) {
            PluginMetadataParser.setSubCategory(resourceDescriptor, resourceType);
        }
        if (discoveryClass == null) {
            discoveryClass = this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), resourceDescriptor.getDiscovery());
        }
        if (componentClass == null) {
            componentClass = this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), resourceDescriptor.getClazz());
        }
        resourceType.setPlugin(this.pluginDescriptor.getName());
        if (resourceDescriptor.getPluginConfiguration() != null) {
            resourceType.setPluginConfigurationDefinition(ConfigurationMetadataParser.parse(resourceType.getName(), resourceDescriptor.getPluginConfiguration()));
        }
        if (resourceDescriptor.getResourceConfiguration() != null) {
            resourceType.setResourceConfigurationDefinition(ConfigurationMetadataParser.parse(resourceType.getName(), resourceDescriptor.getResourceConfiguration()));
        }
        int displayPosition = 1;
        for (MetricDescriptor metricDescriptor : resourceDescriptor.getMetric()) {
            List<MeasurementDefinition> measurementDefinition = MetricsMetadataParser.parseMetricsMetadata(metricDescriptor, resourceType);
            for (MeasurementDefinition def : measurementDefinition) {
                def.setDisplayOrder(displayPosition++);
                resourceType.addMetricDefinition(def);
            }
        }
        for (EventDescriptor eventDescriptor : resourceDescriptor.getEvent()) {
            EventDefinition eventDefinition = EventsMetadataParser.parseEventsMetadata(eventDescriptor, resourceType);
            resourceType.addEventDefinition(eventDefinition);
        }
        for (OperationDescriptor operationDescriptor : resourceDescriptor.getOperation()) {
            resourceType.addOperationDefinition(OperationsMetadataParser.parseOperationDescriptor(operationDescriptor));
        }
        for (ProcessScanDescriptor processMatch : resourceDescriptor.getProcessScan()) {
            resourceType.addProcessScan(new ProcessScan(processMatch.getQuery(), processMatch.getName()));
        }
        for (ContentDescriptor contentDescriptor : resourceDescriptor.getContent()) {
            resourceType.addPackageType(ContentMetadataParser.parseContentDescriptor(contentDescriptor));
        }
        if (resourceDescriptor.getSubcategories() != null) {
            for (SubCategoryDescriptor subCategoryDescriptor : resourceDescriptor.getSubcategories().getSubcategory()) {
                resourceType.addChildSubCategory(SubCategoriesMetadataParser.getSubCategory(subCategoryDescriptor, resourceType));
            }
        }
        this.registerResourceTypeAndComponentClasses(resourceType, discoveryClass, componentClass);
        if (resourceDescriptor instanceof PlatformDescriptor) {
            for (ServerDescriptor serverDescriptor : ((PlatformDescriptor)resourceDescriptor).getServers()) {
                this.parseServerDescriptor(serverDescriptor, resourceType);
            }
            for (ServiceDescriptor serviceDescriptor : ((PlatformDescriptor)resourceDescriptor).getServices()) {
                this.parseServiceDescriptor(serviceDescriptor, resourceType, sourcePlugin);
            }
        }
        if (resourceDescriptor instanceof ServerDescriptor) {
            for (ServerDescriptor serverDescriptor : ((ServerDescriptor)resourceDescriptor).getServers()) {
                this.parseServerDescriptor(serverDescriptor, resourceType);
            }
            for (ServiceDescriptor serviceDescriptor : ((ServerDescriptor)resourceDescriptor).getServices()) {
                this.parseServiceDescriptor(serviceDescriptor, resourceType, sourcePlugin);
            }
        }
        if (resourceDescriptor instanceof ServiceDescriptor) {
            for (ServiceDescriptor serviceDescriptor : ((ServiceDescriptor)resourceDescriptor).getServices()) {
                this.parseServiceDescriptor(serviceDescriptor, resourceType, sourcePlugin);
            }
        }
    }

    private String getFullyQualifiedComponentClassName(String packageName, String baseClassName) {
        if (baseClassName == null) {
            return null;
        }
        if (baseClassName.indexOf(46) > -1 || packageName == null) {
            return baseClassName;
        }
        return packageName + '.' + baseClassName;
    }

    public String getDiscoveryComponentClass(ResourceType resourceType) {
        return this.discoveryClasses.get(resourceType);
    }

    public String getComponentClass(ResourceType resourceType) {
        return this.componentClasses.get(resourceType);
    }

    private void registerResourceTypeAndComponentClasses(ResourceType resourceType, String discoveryClass, String componentClass) {
        this.resourceTypes.add(resourceType);
        this.componentClasses.put(resourceType, componentClass);
        if (discoveryClass != null) {
            this.discoveryClasses.put(resourceType, discoveryClass);
        }
    }

    private Map<String, ServerDescriptor> getPluginServerDescriptors(String pluginName) {
        HashMap<String, ServerDescriptor> pluginServerDescriptors = new HashMap<String, ServerDescriptor>();
        PluginMetadataParser pluginParser = pluginName.equals(this.pluginDescriptor.getName()) ? this : this.parsersByPlugin.get(pluginName);
        if (pluginParser != null) {
            for (ServerDescriptor server : pluginParser.pluginDescriptor.getServers()) {
                pluginServerDescriptors.put(server.getName(), server);
            }
        }
        return pluginServerDescriptors;
    }

    private Map<String, ServiceDescriptor> getPluginServiceDescriptors(String pluginName) {
        HashMap<String, ServiceDescriptor> pluginServiceDescriptors = new HashMap<String, ServiceDescriptor>();
        PluginMetadataParser pluginParser = pluginName.equals(this.pluginDescriptor.getName()) ? this : this.parsersByPlugin.get(pluginName);
        if (pluginParser != null) {
            this.addPluginServiceDescriptors(pluginParser.pluginDescriptor.getServices(), pluginServiceDescriptors);
            this.addPluginServiceDescriptors(pluginParser.pluginDescriptor.getServers(), pluginServiceDescriptors);
        }
        return pluginServiceDescriptors;
    }

    private String getPluginPackage(String pluginName) {
        String packageName = null;
        PluginMetadataParser pluginParser = pluginName.equals(this.pluginDescriptor.getName()) ? this : this.parsersByPlugin.get(pluginName);
        if (pluginParser != null) {
            packageName = pluginParser.pluginDescriptor.getPackage();
        }
        return packageName;
    }

    private void addPluginServiceDescriptors(Collection<? extends ResourceDescriptor> parents, Map<String, ServiceDescriptor> descriptors) {
        if (parents != null) {
            for (ResourceDescriptor resourceDescriptor : parents) {
                List<ServiceDescriptor> services = null;
                if (resourceDescriptor instanceof ServerDescriptor) {
                    services = ((ServerDescriptor)resourceDescriptor).getServices();
                }
                if (resourceDescriptor instanceof ServiceDescriptor) {
                    services = ((ServiceDescriptor)resourceDescriptor).getServices();
                }
                for (ServiceDescriptor service : services) {
                    descriptors.put(service.getName(), service);
                    this.addPluginServiceDescriptors(service.getServices(), descriptors);
                }
            }
        }
    }

    private ResourceType getResourceTypeFromPlugin(String resourceTypeName, String pluginName) {
        PluginMetadataParser pluginParser;
        if (resourceTypeName != null && pluginName != null && (pluginParser = pluginName.equals(this.pluginDescriptor.getName()) ? this : this.parsersByPlugin.get(pluginName)) != null) {
            for (ResourceType type : pluginParser.resourceTypes) {
                if (!resourceTypeName.equals(type.getName())) continue;
                return type;
            }
        }
        return null;
    }

    private ResourceCreationDataType convertCreationDataType(ResourceCreationData creationType) {
        switch (creationType) {
            case CONTENT: {
                return ResourceCreationDataType.CONTENT;
            }
            case CONFIGURATION: {
                return ResourceCreationDataType.CONFIGURATION;
            }
        }
        return null;
    }

    private CreateDeletePolicy convertCreateDeletePolicy(ResourceCreateDeletePolicy policy) {
        switch (policy) {
            case BOTH: {
                return CreateDeletePolicy.BOTH;
            }
            case CREATE_ONLY: {
                return CreateDeletePolicy.CREATE_ONLY;
            }
            case DELETE_ONLY: {
                return CreateDeletePolicy.DELETE_ONLY;
            }
            case NEITHER: {
                return CreateDeletePolicy.NEITHER;
            }
        }
        return null;
    }
}

